/*
 * Decompiled with CFR 0.152.
 */
package kilim.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kilim.analysis.FileLister;
import kilim.analysis.KilimContext;
import kilim.tools.AsmException;
import kilim.tools.EOF;
import kilim.tools.Line;
import kilim.tools.StringList;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class Asm {
    static boolean quiet = false;
    static boolean force = false;
    static String outputDir = ".";
    static Pattern wsPattern = Pattern.compile("\\s+");
    static Pattern commentPattern = Pattern.compile("^;.*$| ;[^\"]*");
    private boolean eofOK = false;
    private ClassWriter cv;
    private MethodVisitor mv;
    private int maxLocals = 1;
    private int maxStack = 1;
    private HashSet<String> declaredLabels = new HashSet();
    private HashMap<String, Label> labels = new HashMap();
    private String className;
    private String methodName;
    private String fileName;
    private Line line;
    private Line bufferedLine;
    private Matcher lastMatch = null;
    private Pattern lastPattern = null;
    private LineNumberReader reader;
    private boolean skip = false;
    static HashMap<String, Integer> modifiers = new HashMap();
    private static String classNamePatternStr;
    private static String modifierPatternStr;
    private static Pattern classPattern;
    private static Pattern superPattern;
    private static Pattern implementsPattern;
    private static String namePatternStr;
    private static String descPatternStr;
    private static Pattern fieldPattern;
    private static String methodNamePatternStr;
    private static Pattern methodPattern;
    private static Pattern throwsPattern;
    private static Pattern labelPattern;
    static Pattern localsPattern;
    static Pattern stackPattern;
    static Pattern catchPattern;
    static Pattern annotationPattern;
    static String[] opcodeStrs;
    private static boolean computeFrames;
    private static final HashMap<String, Integer> opcodeMap;
    private static final byte[] visitTypes;
    private static final int INSN = 0;
    private static final int VAR = 1;
    private static final int LDC = 2;
    private static final int JUMP = 3;
    private static final int TABLESWITCH = 4;
    private static final int LOOKUPSWITCH = 5;
    private static final int FIELD = 6;
    private static final int METHOD = 7;
    private static final int TYPE = 8;
    private static final int MULTIANEWARRAY = 9;
    private static final int INT = 10;
    private static final int IINC = 11;
    static final Pattern insnPattern;
    static final Pattern quotedPattern;
    static final Pattern casePattern;
    static final Pattern methodInvokePattern;
    static final Pattern fieldSpecPattern;
    boolean eofSeen = false;

    public static void main(String[] args) throws IOException {
        List<String> files = Asm.parseArgs(args);
        for (String arg : files) {
            Asm asm = new Asm(arg);
            asm.parse();
            if (asm.skip) continue;
            if (!quiet) {
                System.out.println("Asm: " + arg);
            }
            asm.write();
        }
    }

    public Asm(String afileName) throws IOException {
        this.fileName = afileName;
    }

    public Asm parse() throws IOException {
        this.reader = new LineNumberReader(new FileReader(this.fileName));
        this.cv = new ClassWriter(computeFrames ? 2 : 0);
        try {
            this.parseClass();
        }
        catch (EOF eof) {
            if (!this.eofOK) {
                System.err.println("Premature end of file: " + this.fileName);
                System.exit(1);
            }
        }
        catch (AsmException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (RuntimeException e) {
            System.out.println("File: " + this.fileName);
            if (this.methodName != null) {
                System.out.println("Method: " + this.methodName);
            }
            System.out.println("");
            System.out.println("Line " + this.line);
            System.out.println("Last pattern match: " + this.lastPattern);
            throw e;
        }
        return this;
    }

    private void parseClass() {
        this.readLine();
        int acc = 0;
        if (!this.lineMatch(classPattern)) {
            this.err("Expected .class or .interface declaration");
        }
        if (this.line.startsWith(".interface")) {
            acc = 512;
        }
        acc |= this.parseModifiers(this.group(2));
        this.className = this.group(4);
        if (!force && this.check()) {
            this.skip = true;
            return;
        }
        String superClassName = this.parseSuper();
        String[] interfaces = this.parseInterfaces();
        this.cv.visit(computeFrames ? 50 : 49, acc, this.className, null, superClassName, interfaces);
        this.parseClassBody();
        this.eofOK = true;
    }

    private int parseModifiers(String s) {
        if (s == null) {
            return 0;
        }
        if ((s = s.trim()).equals("")) {
            return 0;
        }
        int acc = 0;
        for (String modifier : Asm.split(wsPattern, s)) {
            if (!modifiers.containsKey(modifier)) {
                this.err("Modifier " + modifier + " not recognized");
            }
            acc |= modifiers.get(modifier).intValue();
        }
        return acc;
    }

    private String parseSuper() {
        this.readLine();
        if (!this.lineMatch(superPattern)) {
            this.err("Expected .super <superclass>");
        }
        return this.group(1);
    }

    private String[] parseInterfaces() {
        StringList interfaces = new StringList();
        while (true) {
            this.readLine();
            if (!this.lineMatch(implementsPattern)) {
                this.putBackLine();
                return interfaces.toArray();
            }
            interfaces.add(this.group(1));
        }
    }

    private void parseClassBody() {
        while (true) {
            this.readLine();
            if (this.lineMatch(fieldPattern)) {
                this.parseField();
                continue;
            }
            if (this.lineMatch(methodPattern)) {
                this.parseMethod();
                continue;
            }
            if (this.lineMatch(annotationPattern)) {
                this.readLine();
                if (this.line.startsWith(".end annotation")) continue;
                this.err(".end annotation not present");
                continue;
            }
            this.err("Expected field, method or annotation in class body");
        }
    }

    private void parseField() {
        String name = this.group(3);
        String desc = this.group(4);
        String valueStr = this.group(6);
        Object value = valueStr == null ? null : this.parseValue(valueStr, desc.equals("D") || desc.equals("J"));
        this.cv.visitField(this.parseModifiers(this.group(1)), name, desc, null, value);
    }

    private void parseMethod() {
        this.eofOK = false;
        this.methodName = this.group(3);
        int acc = this.parseModifiers(this.group(1));
        String desc = this.group(4);
        String[] exceptions = this.parseMethodExceptions();
        this.mv = this.cv.visitMethod(acc, this.methodName, desc, null, exceptions);
        this.parseMethodBody();
        this.eofOK = true;
    }

    private String[] parseMethodExceptions() {
        StringList l = new StringList();
        while (true) {
            this.readLine();
            if (!this.lineMatch(throwsPattern)) {
                this.putBackLine();
                return l.toArray();
            }
            l.add(this.group(1));
        }
    }

    private void parseMethodBody() {
        this.labels.clear();
        this.declaredLabels.clear();
        this.mv.visitCode();
        while (true) {
            this.readLine();
            if (this.line.startsWith(".end method")) break;
            if (this.line.startsWith(".")) {
                this.parseMethodDirective();
                continue;
            }
            if (this.lineMatch(labelPattern)) {
                this.parseLabel();
                continue;
            }
            this.parseInstructions();
        }
        this.checkLabelDeclarations();
        this.mv.visitMaxs(this.maxStack, this.maxLocals);
        this.mv.visitEnd();
    }

    private void parseLabel() {
        String str = this.group(1);
        if (this.declaredLabels.contains(str)) {
            this.err("Duplicate label " + str);
        } else {
            this.declaredLabels.add(str);
            Label l = this.getLabel(str);
            this.mv.visitLabel(l);
        }
    }

    private void checkLabelDeclarations() {
        for (String key : this.labels.keySet()) {
            if (this.declaredLabels.contains(key)) continue;
            throw new AsmException("Label " + key + " not declared in " + this.methodName);
        }
    }

    private void parseMethodDirective() {
        if (this.lineMatch(localsPattern)) {
            this.maxLocals = this.parseInt(this.group(1));
        } else if (this.lineMatch(stackPattern)) {
            this.maxStack = this.parseInt(this.group(1));
        } else if (this.lineMatch(catchPattern)) {
            String exceptionType = this.group(1);
            if (exceptionType.equals("all")) {
                exceptionType = null;
            }
            Label fromLabel = this.getLabel(this.group(2));
            Label toLabel = this.getLabel(this.group(3));
            Label usingLabel = this.getLabel(this.group(4));
            this.mv.visitTryCatchBlock(fromLabel, toLabel, usingLabel, exceptionType);
        } else if (this.lineMatch(annotationPattern)) {
            this.parseAnnotation();
        } else if (!quiet) {
            System.err.println("Directive ignored: " + this.line);
        }
    }

    private void parseAnnotation() {
        String s = this.group(2);
        boolean visible = s == null ? false : s.equals("visible");
        String desc = this.group(3);
        this.mv.visitAnnotation(desc, visible);
        this.readLine();
        if (!this.line.startsWith(".end annotation")) {
            this.err(".end annotation not present");
        }
    }

    private void parseInstructions() {
        if (!this.lineMatch(insnPattern)) {
            this.err("Instruction is not well-formed");
        }
        String insn = this.group(1);
        String operand = null;
        if (this.groupCount() == 3 && (operand = this.group(3)) != null) {
            operand = operand.trim();
        }
        if (!opcodeMap.containsKey(insn)) {
            this.err("Instruction " + insn + " not recognized");
        }
        int opcode = opcodeMap.get(insn);
        switch (visitTypes[opcode]) {
            case 0: {
                this.mv.visitInsn(opcode);
                break;
            }
            case 1: {
                this.mv.visitVarInsn(opcode, this.parseInt(operand));
                break;
            }
            case 2: {
                this.mv.visitLdcInsn(this.parseValue(operand, opcode == 20));
                break;
            }
            case 3: {
                Label l = this.getLabel(operand);
                this.mv.visitJumpInsn(opcode, l);
                break;
            }
            case 4: {
                int min = this.parseInt(operand);
                ArrayList<Label> labelList = new ArrayList<Label>(10);
                Label defLabel = null;
                while (true) {
                    this.readLine();
                    if (this.line.startsWith("default")) break;
                    labelList.add(this.getLabel(this.line.s));
                }
                this.lineMatch(casePattern);
                defLabel = this.getLabel(this.group(2));
                Label[] labels = labelList.toArray(new Label[labelList.size()]);
                int max = min + labels.length - 1;
                this.mv.visitTableSwitchInsn(min, max, defLabel, labels);
                break;
            }
            case 5: {
                Label lab;
                ArrayList<Integer> keyList = new ArrayList<Integer>(10);
                ArrayList<Label> labelList = new ArrayList<Label>(10);
                Label defLabel = null;
                while (true) {
                    this.readLine();
                    if (this.lineMatch(casePattern)) {
                        lab = this.getLabel(this.group(2));
                        String keystr = this.group(1);
                        if (keystr.equals("default")) break;
                        int key = this.parseInt(keystr);
                        keyList.add(key);
                        labelList.add(lab);
                        continue;
                    }
                    this.err("Ill-formed switch instruction");
                }
                defLabel = lab;
                Label[] labels = labelList.toArray(new Label[labelList.size()]);
                int[] keys = new int[keyList.size()];
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = (Integer)keyList.get(i);
                }
                this.mv.visitLookupSwitchInsn(defLabel, keys, labels);
                break;
            }
            case 6: {
                if (operand == null || !this.match(operand, fieldSpecPattern)) {
                    this.err("Expected field access of the form foo/Bar/fieldName I");
                }
                String owner = this.group(1);
                String name = this.group(2);
                String desc = this.group(3);
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                break;
            }
            case 7: {
                if (operand == null || !this.match(operand, methodInvokePattern)) {
                    this.err("Expected method invocation of the form /foo/Bar/methodName(IJ)V");
                }
                String owner = this.group(1);
                String name = this.group(2);
                String desc = this.group(3);
                boolean itf = false;
                try {
                    itf = KilimContext.DEFAULT.detector.mirrors.classForName(owner).isInterface();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
                break;
            }
            case 8: {
                this.opcheck("expected type", operand);
                this.mv.visitTypeInsn(opcode, operand);
                break;
            }
            case 9: {
                this.opcheck("expected array type and dimensions", operand);
                String[] words = Asm.split(wsPattern, operand);
                this.mv.visitMultiANewArrayInsn(words[0], this.parseInt(words[1]));
                break;
            }
            case 10: {
                int op = -1;
                if (opcode == 188) {
                    if (operand.equals("boolean")) {
                        op = 4;
                    } else if (operand.equals("char")) {
                        op = 5;
                    } else if (operand.equals("float")) {
                        op = 6;
                    } else if (operand.equals("double")) {
                        op = 7;
                    } else if (operand.equals("byte")) {
                        op = 8;
                    } else if (operand.equals("short")) {
                        op = 9;
                    } else if (operand.equals("int")) {
                        op = 10;
                    } else if (operand.equals("long")) {
                        op = 11;
                    } else {
                        this.err("Unknown type for newarray: " + operand);
                    }
                } else {
                    op = this.parseInt(operand);
                }
                this.mv.visitIntInsn(opcode, op);
                break;
            }
            case 11: {
                this.opcheck("Expected iinc <var> <inc amount>", operand);
                String[] words = Asm.split(wsPattern, operand);
                int var = this.parseInt(words[0]);
                int increment = this.parseInt(words[1]);
                this.mv.visitIincInsn(var, increment);
                break;
            }
            default: {
                this.err("INTERNAL ERROR: UNKNOWN TYPE OF INSTRUCTION");
            }
        }
    }

    private void opcheck(String errMessage, String operand) {
        if (operand == null) {
            this.err(errMessage);
        }
    }

    private Object parseValue(String s, boolean isDoubleWord) {
        Object ret = null;
        if (s == null) {
            this.err("Expected constant value ");
        }
        if (s.startsWith("\"")) {
            if (isDoubleWord) {
                this.err("long or double value expected instead of string");
            }
            if (s.charAt(s.length() - 1) != '\"') {
                this.err("Ill-formed string");
            }
            ret = s.substring(1, s.length() - 1);
        } else {
            ret = s.startsWith("L") ? Type.getType((String)s) : (s.indexOf(46) == -1 ? (Number)(isDoubleWord ? (Number)this.parseLong(s) : (Number)this.parseInt(s)) : (Number)(isDoubleWord ? (Number)this.parseDouble(s) : (Number)Float.valueOf(this.parseFloat(s))));
        }
        return ret;
    }

    int parseInt(String s) {
        if (s == null) {
            this.err("Expected integer");
        }
        try {
            return Integer.parseInt(s.trim());
        }
        catch (NumberFormatException nfe) {
            this.err("Expected integer value, got " + s);
            return 0;
        }
    }

    long parseLong(String s) {
        if (s == null) {
            this.err("Expected long");
        }
        try {
            return Long.parseLong(s.trim());
        }
        catch (NumberFormatException nfe) {
            this.err("Expected long value, got " + s);
            return 0L;
        }
    }

    float parseFloat(String s) {
        if (s == null) {
            this.err("Expected float");
        }
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException nfe) {
            this.err("Expected float, got " + s);
            return 0.0f;
        }
    }

    double parseDouble(String s) {
        if (s == null) {
            this.err("Expected float");
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException nfe) {
            this.err("Expected double, got " + s);
            return 0.0;
        }
    }

    Label getLabel(String s) {
        Label ret;
        if (s == null) {
            this.err("Expected label string");
        }
        if ((ret = this.labels.get(s)) == null) {
            ret = new Label();
            this.labels.put(s, ret);
        }
        return ret;
    }

    private void err(String s) {
        String msg = String.format("%s: %d: %s\n", this.fileName, this.line.n, s);
        msg = msg + this.line.s;
        throw new AsmException(msg);
    }

    private Line readLine() {
        Line l;
        String s;
        if (this.bufferedLine != null) {
            this.line = this.bufferedLine;
            this.bufferedLine = null;
            return this.line;
        }
        do {
            l = this.getLine();
            s = l.s.trim();
        } while ((s = commentPattern.matcher(s).replaceAll("")).length() <= 0);
        l.s = s;
        this.line = l;
        return l;
    }

    private void putBackLine() {
        this.bufferedLine = this.line;
    }

    private Line getLine() {
        if (this.eofSeen) {
            throw new EOF();
        }
        try {
            String s = this.reader.readLine();
            if (s == null) {
                this.eofSeen = true;
                s = "";
            }
            return new Line(this.reader.getLineNumber(), s);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new EOF();
        }
    }

    boolean match(String s, Pattern p) {
        this.lastMatch = p.matcher(s);
        this.lastPattern = p;
        return this.lastMatch.find();
    }

    boolean lineMatch(Pattern p) {
        this.lastMatch = p.matcher(this.line.s);
        this.lastPattern = p;
        return this.lastMatch.find();
    }

    String group(int i) {
        String ret = this.lastMatch.group(i);
        return ret;
    }

    int groupCount() {
        return this.lastMatch.groupCount();
    }

    static String[] split(Pattern p, String s) {
        return p.split(s);
    }

    private String outputName() {
        return outputDir + '/' + this.className + ".class";
    }

    private boolean check() {
        return FileLister.check(this.fileName, this.outputName());
    }

    private void write() throws IOException {
        String dir = outputDir + "/" + Asm.getDirName(this.className);
        Asm.mkdir(dir);
        String fileName = this.outputName();
        FileOutputStream fos = new FileOutputStream(fileName);
        fos.write(this.cv.toByteArray());
        fos.close();
        System.out.println("Wrote: " + fileName);
    }

    private static void mkdir(String dir) throws IOException {
        File f = new File(dir);
        if (!f.exists() && !f.mkdirs()) {
            throw new IOException("Unable to create directory: " + dir);
        }
    }

    private static String getDirName(String className) {
        int end = className.lastIndexOf(47);
        return end == -1 ? "" : className.substring(0, end);
    }

    private static List<String> parseArgs(String[] args) {
        ArrayList<String> ret = new ArrayList<String>(args.length);
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-d")) {
                outputDir = args[++i];
                continue;
            }
            if (arg.equals("-q")) {
                quiet = true;
                continue;
            }
            if (arg.equals("-f")) {
                force = true;
                continue;
            }
            if (arg.equals("-nf")) {
                computeFrames = false;
                continue;
            }
            ret.add(arg);
        }
        return ret;
    }

    static {
        modifiers.put("public", 1);
        modifiers.put("private", 2);
        modifiers.put("protected", 4);
        modifiers.put("static", 8);
        modifiers.put("final", 16);
        modifiers.put("super", 32);
        modifiers.put("synchronized", 32);
        modifiers.put("volatile", 64);
        modifiers.put("transient", 128);
        modifiers.put("native", 256);
        modifiers.put("interface", 512);
        modifiers.put("abstract", 1024);
        modifiers.put("strict", 2048);
        modifiers.put("enum", 16384);
        classNamePatternStr = "[\\w/$]+";
        modifierPatternStr = "public|private|protected|static|final|synchronized|volatile|transient|native|abstract|strict| ";
        classPattern = Pattern.compile("\\.(class|interface) ((" + modifierPatternStr + ")*)(" + classNamePatternStr + ")$");
        superPattern = Pattern.compile("\\.super (" + classNamePatternStr + ")$");
        implementsPattern = Pattern.compile("\\.implements +(" + classNamePatternStr + ")$");
        namePatternStr = "[$\\w]+";
        descPatternStr = "[$\\[\\w/;]+";
        fieldPattern = Pattern.compile(".field +((" + modifierPatternStr + ")*) +(" + namePatternStr + ") +(" + descPatternStr + ") *(= *(.*))?");
        methodNamePatternStr = "[<>\\w]+";
        methodPattern = Pattern.compile(".method +((" + modifierPatternStr + ")*) (" + methodNamePatternStr + ") *([(][^\\s]+)");
        throwsPattern = Pattern.compile("^ *\\.throws +(" + classNamePatternStr + ")");
        labelPattern = Pattern.compile("^(\\w+) *: *$");
        localsPattern = Pattern.compile(".limit +locals +([0-9]+)");
        stackPattern = Pattern.compile(".limit +stack +([0-9]+)");
        catchPattern = Pattern.compile(".catch +(" + classNamePatternStr + ") +from +([\\w]+) +to +([\\w]+) +using +([\\w]+)");
        annotationPattern = Pattern.compile(".annotation +((visible) )?([\\w/;]+)");
        opcodeStrs = new String[]{"nop", "aconst_null", "iconst_m1", "iconst_0", "iconst_1", "iconst_2", "iconst_3", "iconst_4", "iconst_5", "lconst_0", "lconst_1", "fconst_0", "fconst_1", "fconst_2", "dconst_0", "dconst_1", "bipush", "sipush", "ldc", "ldc_w", "ldc2_w", "iload", "lload", "fload", "dload", "aload", "iload_0", "iload_1", "iload_2", "iload_3", "lload_0", "lload_1", "lload_2", "lload_3", "fload_0", "fload_1", "fload_2", "fload_3", "dload_0", "dload_1", "dload_2", "dload_3", "aload_0", "aload_1", "aload_2", "aload_3", "iaload", "laload", "faload", "daload", "aaload", "baload", "caload", "saload", "istore", "lstore", "fstore", "dstore", "astore", "istore_0", "istore_1", "istore_2", "istore_3", "lstore_0", "lstore_1", "lstore_2", "lstore_3", "fstore_0", "fstore_1", "fstore_2", "fstore_3", "dstore_0", "dstore_1", "dstore_2", "dstore_3", "astore_0", "astore_1", "astore_2", "astore_3", "iastore", "lastore", "fastore", "dastore", "aastore", "bastore", "castore", "sastore", "pop", "pop2", "dup", "dup_x1", "dup_x2", "dup2", "dup2_x1", "dup2_x2", "swap", "iadd", "ladd", "fadd", "dadd", "isub", "lsub", "fsub", "dsub", "imul", "lmul", "fmul", "dmul", "idiv", "ldiv", "fdiv", "ddiv", "irem", "lrem", "frem", "drem", "ineg", "lneg", "fneg", "dneg", "ishl", "lshl", "ishr", "lshr", "iushr", "lushr", "iand", "land", "ior", "lor", "ixor", "lxor", "iinc", "i2l", "i2f", "i2d", "l2i", "l2f", "l2d", "f2i", "f2l", "f2d", "d2i", "d2l", "d2f", "i2b", "i2c", "i2s", "lcmp", "fcmpl", "fcmpg", "dcmpl", "dcmpg", "ifeq", "ifne", "iflt", "ifge", "ifgt", "ifle", "if_icmpeq", "if_icmpne", "if_icmplt", "if_icmpge", "if_icmpgt", "if_icmple", "if_acmpeq", "if_acmpne", "goto", "jsr", "ret", "tableswitch", "lookupswitch", "ireturn", "lreturn", "freturn", "dreturn", "areturn", "return", "getstatic", "putstatic", "getfield", "putfield", "invokevirtual", "invokespecial", "invokestatic", "invokeinterface", "unused", "new", "newarray", "anewarray", "arraylength", "athrow", "checkcast", "instanceof", "monitorenter", "monitorexit", "wide", "multianewarray", "ifnull", "ifnonnull", "goto_w", "jsr_w"};
        computeFrames = true;
        opcodeMap = new HashMap();
        for (int i = 0; i < opcodeStrs.length; ++i) {
            opcodeMap.put(opcodeStrs[i], i);
        }
        opcodeMap.put("invokenonvirtual", opcodeMap.get("invokespecial"));
        visitTypes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 10, 2, 2, 2, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 4, 5, 0, 0, 0, 0, 0, 0, 6, 6, 6, 6, 7, 7, 7, 7, 0, 8, 10, 8, 0, 0, 8, 8, 0, 0, 0, 9, 3, 3, 3, 3};
        insnPattern = Pattern.compile("(\\w+)( +(.*))?");
        quotedPattern = Pattern.compile("(.*)");
        casePattern = Pattern.compile("(\\w+) *: *(\\w+)");
        methodInvokePattern = Pattern.compile("(" + classNamePatternStr + ")[/.](" + methodNamePatternStr + ") *([(].*?[)]" + descPatternStr + ") *(, *\\d+)?");
        fieldSpecPattern = Pattern.compile("([\\w/.$]+)[/.]([\\w$]+) +([^\\s]+)");
    }
}

