/*
 * Decompiled with CFR 0.152.
 */
package kilim.plugins;

import java.io.File;
import kilim.tools.Weaver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="weave", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class KilimMavenPlugin
extends AbstractMojo {
    @Parameter(defaultValue="-q", property="kilim.args", required=false)
    private String args;
    @Parameter(defaultValue="${project.build.outputDirectory}", property="kilim.in", required=true)
    private File in;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", property="kilim.tin", required=true)
    private File tin;
    @Parameter(defaultValue="${project.build.outputDirectory}", property="kilim.out", required=true)
    private File out;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", property="kilim.tout", required=true)
    private File tout;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        try {
            String indir = this.in.getAbsolutePath();
            String tindir = this.tin.getAbsolutePath();
            String outdir = this.out.getAbsolutePath();
            String toutdir = this.tout.getAbsolutePath();
            this.getLog().debug((CharSequence)("kilim weaver input/output dirs are: " + indir + ", " + outdir));
            String[] roots = this.project.getCompileClasspathElements().toArray(new String[0]);
            Weaver.outputDir = outdir;
            this.getLog().debug((CharSequence)("plugin.args: " + this.args));
            if (this.args != null && this.args.length() > 0) {
                Weaver.parseArgs(this.args.split(" "));
            }
            int err = Weaver.doMain(new String[]{indir}, roots);
            this.getLog().debug((CharSequence)"kilim weaver done");
            if (err > 0) {
                throw new MojoExecutionException("Error while weaving the classes");
            }
            this.getLog().debug((CharSequence)("kilim weaver test input/output dirs are: " + tindir + ", " + toutdir));
            String[] troots = this.project.getTestClasspathElements().toArray(new String[0]);
            Weaver.outputDir = toutdir;
            err = Weaver.doMain(new String[]{tindir}, troots);
            this.getLog().debug((CharSequence)"kilim weaver done - tests");
            if (err > 0) {
                throw new MojoExecutionException("Error while weaving the test classes");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while weaving the classes", e);
        }
    }
}

