/*
 * Decompiled with CFR 0.152.
 */
package kilim.mirrors;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kilim.WeavingClassLoader;
import kilim.mirrors.ClassMirrorNotFoundException;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class CachedClassMirrors {
    static final String[] EMPTY_SET = new String[0];
    ConcurrentHashMap<String, ClassMirror> cachedClasses = new ConcurrentHashMap();
    final ClassLoader source;

    public CachedClassMirrors() {
        this.source = this.getClass().getClassLoader();
    }

    public CachedClassMirrors(ClassLoader $source) {
        this.source = $source;
    }

    public ClassMirror classForName(String className) throws ClassMirrorNotFoundException {
        ClassMirror ret = this.cachedClasses.get(className);
        if (ret != null) {
            return ret;
        }
        byte[] code = WeavingClassLoader.findCode(this.source, className);
        if (code != null) {
            return this.mirror(code);
        }
        throw new ClassMirrorNotFoundException(className);
    }

    public ClassMirror mirror(byte[] bytecode) {
        ClassMirror mirror = new ClassMirror(bytecode);
        return this.place(mirror);
    }

    private ClassMirror place(ClassMirror r1) {
        r1.mirrors = this;
        ClassMirror r2 = this.cachedClasses.putIfAbsent(r1.getName(), r1);
        return r2 == null ? r1 : r2;
    }

    public static int getVersion(ClassLoader source, Class klass) {
        String cname = WeavingClassLoader.makeResourceName(klass.getName());
        DataInputStream in = new DataInputStream(source.getResourceAsStream(cname));
        try {
            int magic = in.readInt();
            int minor = in.readUnsignedShort();
            int major = in.readUnsignedShort();
            in.close();
            return major;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public ClassMirror mirror(Class<?> clazz) {
        try {
            return this.classForName(clazz.getName());
        }
        catch (ClassMirrorNotFoundException ex) {
            throw new AssertionError("class-based lookup should never fail", ex);
        }
    }

    private static String map(String word) {
        return word == null ? null : word.replace("/", ".");
    }

    private static String[] map(String[] words) {
        if (words == null) {
            return words;
        }
        String[] mod = new String[words.length];
        for (int ii = 0; ii < mod.length; ++ii) {
            mod[ii] = words[ii].replace("/", ".");
        }
        return mod;
    }

    public static class MethodMirror {
        private String[] exceptions;
        private String desc;
        private String name;
        private int modifiers;
        private boolean isBridge;

        public MethodMirror(int modifiers, String name, String desc, String[] exceptions) {
            this.modifiers = modifiers;
            this.name = name;
            this.desc = desc;
            this.exceptions = exceptions == null ? EMPTY_SET : exceptions;
            this.isBridge = (modifiers & 0x40) > 0;
        }

        public String getName() {
            return this.name;
        }

        public String[] getExceptionTypes() {
            return this.exceptions;
        }

        public String getMethodDescriptor() {
            return this.desc;
        }

        public boolean isBridge() {
            return this.isBridge;
        }

        public int getModifiers() {
            return this.modifiers;
        }
    }

    static class DummyAnnotationVisitor
    extends AnnotationVisitor {
        static DummyAnnotationVisitor singleton = new DummyAnnotationVisitor();

        public DummyAnnotationVisitor() {
            super(458752);
        }

        public void visit(String name, Object value) {
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return this;
        }

        public AnnotationVisitor visitArray(String name) {
            return singleton;
        }

        public void visitEnd() {
        }

        public void visitEnum(String name, String desc, String value) {
        }
    }

    public static class ClassMirror {
        private String name;
        private boolean isInterface;
        private MethodMirror[] declaredMethods;
        private String[] interfaceNames;
        private String superName;
        private int version = 0;
        CachedClassMirrors mirrors;
        private List<MethodMirror> tmpMethodList;

        public ClassMirror(byte[] bytecode) {
            ClassReader cr = new ClassReader(bytecode);
            Visitor visitor = new Visitor();
            cr.accept((ClassVisitor)visitor, 0);
        }

        ClassMirror() {
        }

        public String getName() {
            return this.name;
        }

        public boolean isInterface() {
            return this.isInterface;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ClassMirror) {
                String n1 = this.name;
                ClassMirror mirr = (ClassMirror)obj;
                String n2 = mirr.getName();
                return n1.equals(n2) && mirr.isInterface() == this.isInterface;
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public MethodMirror[] getDeclaredMethods() {
            if (this.declaredMethods != null) {
                return this.declaredMethods;
            }
            this.declaredMethods = new MethodMirror[0];
            return this.declaredMethods;
        }

        public String[] getInterfaces() throws ClassMirrorNotFoundException {
            return this.interfaceNames;
        }

        public String getSuperclass() throws ClassMirrorNotFoundException {
            return this.superName;
        }

        public int version() {
            return this.version & 0xFF;
        }

        public boolean isAssignableFrom(ClassMirror c) throws ClassMirrorNotFoundException {
            ClassMirror supcl;
            if (c == null) {
                return false;
            }
            if (this.equals(c)) {
                return true;
            }
            String sname = c.getSuperclass();
            ClassMirror classMirror = supcl = sname == null ? null : this.mirrors.classForName(sname);
            if (this.isAssignableFrom(supcl)) {
                return true;
            }
            for (String icl : c.getInterfaces()) {
                supcl = this.mirrors.classForName(icl);
                if (!this.isAssignableFrom(supcl)) continue;
                return true;
            }
            return false;
        }

        static /* synthetic */ String[] access$402(ClassMirror x0, String[] x1) {
            x0.interfaceNames = x1;
            return x1;
        }

        static /* synthetic */ MethodMirror[] access$802(ClassMirror x0, MethodMirror[] x1) {
            x0.declaredMethods = x1;
            return x1;
        }

        public class Visitor
        extends ClassVisitor {
            Visitor() {
                super(458752);
            }

            public void visit(int $version, int access, String $name, String signature, String $superName, String[] $interfaces) {
                ClassMirror.this.version = $version;
                ClassMirror.this.name = CachedClassMirrors.map($name);
                ClassMirror.this.superName = CachedClassMirrors.map($superName);
                ClassMirror.access$402(ClassMirror.this, $interfaces == null ? EMPTY_SET : CachedClassMirrors.map($interfaces));
                ClassMirror.this.isInterface = (access & 0x200) > 0;
                if (ClassMirror.this.isInterface) {
                    ClassMirror.this.superName = null;
                }
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (name.equals("<init>")) {
                    return null;
                }
                if (name.equals("<clinit>")) {
                    return null;
                }
                if (ClassMirror.this.tmpMethodList == null) {
                    ClassMirror.this.tmpMethodList = new ArrayList();
                }
                MethodMirror mirror = new MethodMirror(access, name, desc, CachedClassMirrors.map(exceptions));
                ClassMirror.this.tmpMethodList.add(mirror);
                return null;
            }

            public void visitEnd() {
                if (ClassMirror.this.tmpMethodList != null) {
                    ClassMirror.access$802(ClassMirror.this, new MethodMirror[ClassMirror.this.tmpMethodList.size()]);
                    int i = 0;
                    for (MethodMirror mm : ClassMirror.this.tmpMethodList) {
                        ((ClassMirror)ClassMirror.this).declaredMethods[i++] = mm;
                    }
                    ClassMirror.this.tmpMethodList = null;
                }
            }

            public void visitSource(String source, String debug) {
            }

            public void visitNestMember(String nestMember) {
            }

            public void visitNestHost(String nestHost) {
            }

            public void visitOuterClass(String owner, String name, String desc) {
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return DummyAnnotationVisitor.singleton;
            }

            public void visitAttribute(Attribute attr) {
            }

            public void visitInnerClass(String name, String outerName, String innerName, int access) {
            }

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                return null;
            }
        }
    }
}

