/*
 * Decompiled with CFR 0.152.
 */
package kilim.concurrent;

import java.util.NoSuchElementException;
import java.util.concurrent.locks.LockSupport;
import kilim.concurrent.MPSCQueueL3Pad;
import kilim.concurrent.UnsafeAccess;

public class MPSCQueue<E>
extends MPSCQueueL3Pad<E> {
    private static final BackOffStrategy CAS_BACKOFF = BackOffStrategy.getStrategy("cas.backoff", BackOffStrategy.SPIN);

    public MPSCQueue(int capacity) {
        super(capacity);
    }

    private long getHead() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, HEAD_OFFSET);
    }

    private void lazySetHead(long l) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, HEAD_OFFSET, l);
    }

    private long getTail() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, TAIL_OFFSET);
    }

    private boolean casTail(long expect, long newValue) {
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this, TAIL_OFFSET, expect, newValue);
    }

    public boolean add(E e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException("Queue is full");
    }

    private long elementOffsetInBuffer(long index) {
        return ARRAY_BASE + ((index & this.mask) << ELEMENT_SHIFT);
    }

    public boolean offer(E e) {
        long currentTail;
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        int missCount = 0;
        while (true) {
            if ((currentTail = this.getTail()) == Long.MAX_VALUE) {
                System.out.println("bug");
            }
            long wrapPoint = currentTail - (long)this.capacity;
            if (this.getHead() <= wrapPoint) {
                return false;
            }
            if (this.casTail(currentTail, currentTail + 1L)) break;
            missCount = CAS_BACKOFF.backoff(missCount);
        }
        UnsafeAccess.UNSAFE.putOrderedObject(this.buffer, this.elementOffsetInBuffer(currentTail), e);
        return true;
    }

    public boolean hasSpace() {
        long currentTail = this.getTail();
        Object e = UnsafeAccess.UNSAFE.getObjectVolatile(this.buffer, this.elementOffsetInBuffer(currentTail));
        return e == null;
    }

    public E poll() {
        long offset = this.elementOffsetInBuffer(this.head);
        Object e = UnsafeAccess.UNSAFE.getObjectVolatile(this.buffer, offset);
        if (null == e) {
            return null;
        }
        UnsafeAccess.UNSAFE.putObject(this.buffer, offset, null);
        this.lazySetHead(this.head + 1L);
        return (E)e;
    }

    public void fill(E[] buf) {
        int n = buf.length;
        for (int i = 0; i < n; ++i) {
            buf[i] = null;
            buf[i] = this.poll();
            if (buf[i] != null) continue;
            return;
        }
    }

    public E remove() {
        E e = this.poll();
        if (null == e) {
            throw new NoSuchElementException("Queue is empty");
        }
        return e;
    }

    public boolean isEmpty() {
        E e = this.peek();
        return e == null;
    }

    public E element() {
        E e = this.peek();
        if (null == e) {
            throw new NoSuchElementException("Queue is empty");
        }
        return e;
    }

    public E peek() {
        long currentHead = this.getHead();
        return this.getElement(currentHead);
    }

    private E getElement(long index) {
        return (E)UnsafeAccess.UNSAFE.getObject(this.buffer, this.elementOffsetInBuffer(index));
    }

    public int size() {
        long currentProducerIndex;
        long currentConsumerIndexBefore;
        long currentConsumerIndexAfter = this.getHead();
        do {
            currentConsumerIndexBefore = currentConsumerIndexAfter;
            currentProducerIndex = this.getHead();
        } while (currentConsumerIndexBefore != (currentConsumerIndexAfter = this.getTail()));
        return (int)(currentProducerIndex - currentConsumerIndexBefore);
    }

    public static enum BackOffStrategy {
        SPIN{

            @Override
            public int backoff(int called) {
                return ++called;
            }
        }
        ,
        YIELD{

            @Override
            public int backoff(int called) {
                Thread.yield();
                return called++;
            }
        }
        ,
        PARK{

            @Override
            public int backoff(int called) {
                LockSupport.parkNanos(1L);
                return called++;
            }
        }
        ,
        SPIN_YIELD{

            @Override
            public int backoff(int called) {
                if (called > 1000) {
                    Thread.yield();
                }
                return called++;
            }
        };


        public abstract int backoff(int var1);

        public static BackOffStrategy getStrategy(String propertyName, BackOffStrategy defaultS) {
            try {
                return BackOffStrategy.valueOf(System.getProperty(propertyName));
            }
            catch (Exception e) {
                return defaultS;
            }
        }
    }
}

