/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import java.util.Arrays;
import kilim.analysis.IncompatibleTypesException;
import kilim.analysis.TypeDesc;
import kilim.mirrors.Detector;

public class Value {
    public static Object NO_VAL = new Object();
    public static Value V_UNDEFINED = new Value(0, "UNDEFINED", NO_VAL);
    private String typeDesc;
    private Object constVal;
    private int numSites;
    private int[] sites;

    public int getNumSites() {
        return this.numSites;
    }

    public int[] getCreationSites() {
        return this.sites;
    }

    public String getTypeDesc() {
        return this.typeDesc;
    }

    public Object getConstVal() {
        return this.constVal;
    }

    private Value(int aPos, String aDesc, Object aConst) {
        this.sites = new int[2];
        this.numSites = 1;
        this.sites[0] = aPos;
        this.typeDesc = aDesc;
        this.constVal = aConst;
    }

    private Value(int newNumSites, int[] newSites, String newType, Object newConst) {
        Arrays.sort(newSites, 0, newNumSites);
        this.numSites = newNumSites;
        this.sites = newSites;
        this.typeDesc = newType;
        this.constVal = newConst;
    }

    public Value merge(Detector det, Value other) {
        Object newConst;
        String newType;
        int[] newSites = new int[this.numSites + other.numSites];
        for (int i = 0; i < newSites.length; ++i) {
            newSites[i] = -1;
        }
        int newNumSites = this.mergeSites(newSites, other);
        try {
            newType = TypeDesc.mergeType(det, this.typeDesc, other.typeDesc);
        }
        catch (IncompatibleTypesException e) {
            newType = "UNDEFINED";
        }
        Object object = newConst = this.constVal.equals(other.constVal) ? this.constVal : NO_VAL;
        if (newNumSites != this.numSites || newType != this.typeDesc || newConst != this.constVal) {
            return new Value(newNumSites, newSites, newType, newConst);
        }
        return this;
    }

    private int mergeSites(int[] newSites, Value other) {
        int i;
        int uniqueNumSites = 0;
        for (i = 0; i < this.numSites; ++i) {
            uniqueNumSites += this.addTo(newSites, this.sites[i]);
        }
        for (i = 0; i < other.numSites; ++i) {
            uniqueNumSites += this.addTo(newSites, other.sites[i]);
        }
        return uniqueNumSites;
    }

    private int addTo(int[] newSites, int site) {
        for (int i = 0; i < newSites.length; ++i) {
            int s = newSites[i];
            if (s == -1) {
                newSites[i] = site;
                return 1;
            }
            if (s != site) continue;
            return 0;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Value other = (Value)obj;
        if (this.typeDesc.equals(other.typeDesc) && this.constVal.equals(other.constVal) && this.numSites == other.numSites) {
            for (int i = 0; i < this.numSites; ++i) {
                if (this.sites[i] == other.sites[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = this.typeDesc.hashCode();
        for (int i = 0; i < this.numSites; ++i) {
            h ^= this.sites[i];
        }
        return h;
    }

    public static Value make(int pos, String desc) {
        return new Value(pos, desc, NO_VAL);
    }

    public static Value make(int pos, String desc, Object aConstVal) {
        return new Value(pos, desc, aConstVal);
    }

    public boolean isCategory2() {
        return this.category() == 2;
    }

    public boolean isCategory1() {
        return this.category() == 1;
    }

    public String toString() {
        if (this.numSites == 0 && this.typeDesc == "UNDEFINED") {
            return "undef";
        }
        StringBuffer sb = new StringBuffer(40);
        sb.append(this.typeDesc).append('[');
        for (int i = 0; i < this.numSites; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(this.sites[i]);
        }
        sb.append(']');
        if (this.constVal != NO_VAL) {
            sb.append(" == ").append(this.constVal.toString());
        }
        return sb.toString();
    }

    public boolean isConstant() {
        return this.constVal != NO_VAL || this.typeDesc == "NULL";
    }

    public int category() {
        return TypeDesc.isDoubleWord(this.typeDesc) ? 2 : 1;
    }
}

