/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import kilim.Constants;
import kilim.analysis.KilimContext;
import kilim.analysis.TypeDesc;
import kilim.analysis.VMType;
import kilim.mirrors.CachedClassMirrors;
import kilim.mirrors.ClassMirrorNotFoundException;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class SAMweaver
implements Constants {
    String interfaceName;
    String methodName;
    String desc;
    boolean itf;
    int index = -1;
    KilimContext context;

    public SAMweaver(KilimContext context, String interfaceName, String methodName, String desc, boolean itf) {
        this.interfaceName = interfaceName;
        this.methodName = methodName;
        this.desc = desc;
        this.itf = itf;
        this.context = context;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SAMweaver) {
            SAMweaver that = (SAMweaver)obj;
            return this.desc.equals(that.desc) && this.methodName.equals(that.methodName) && this.interfaceName.equals(that.interfaceName);
        }
        return false;
    }

    public String toString() {
        return this.interfaceName + "." + this.methodName + this.desc + " ->" + this.getShimMethodName();
    }

    public int hashCode() {
        return this.methodName.hashCode() ^ this.desc.hashCode();
    }

    String getShimMethodName() {
        assert (this.index >= 0);
        return "$shim$" + this.index;
    }

    String getShimDesc() {
        String shim = this.desc.replace("(", "(" + TypeDesc.getInterned(this.interfaceName));
        return shim.contains("Lkilim/Fiber;)") ? shim : shim.replace(")", "Lkilim/Fiber;)");
    }

    public void accept(ClassVisitor cv) {
        String shimDesc = this.getShimDesc();
        MethodVisitor mv = cv.visitMethod(10, this.getShimMethodName(), shimDesc, null, this.getExceptions());
        int ivar = 0;
        for (String argType : TypeDesc.getArgumentTypes(shimDesc)) {
            int vmt = VMType.toVmType(argType);
            mv.visitVarInsn(VMType.loadInsn[vmt], ivar);
            ivar += VMType.category[vmt];
        }
        int fiberVar = ivar - 1;
        String fiberDesc = this.desc.replace(")", "Lkilim/Fiber;)");
        if (this.itf) {
            mv.visitMethodInsn(185, this.interfaceName, this.methodName, fiberDesc, true);
        } else {
            mv.visitMethodInsn(182, this.interfaceName, this.methodName, fiberDesc, false);
        }
        mv.visitVarInsn(25, fiberVar);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "kilim/Fiber", "setCallee", "(Ljava/lang/Object;)V", false);
        String retDesc = TypeDesc.getReturnTypeDesc(shimDesc);
        if (retDesc.charAt(0) == 'V') {
            mv.visitInsn(177);
        } else {
            int vmt = VMType.toVmType(retDesc);
            mv.visitInsn(VMType.retInsn[vmt]);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    static String[] internalName(String[] words) {
        if (words == null) {
            return words;
        }
        String[] mod = new String[words.length];
        for (int ii = 0; ii < mod.length; ++ii) {
            mod[ii] = words[ii].replace('.', '/');
        }
        return mod;
    }

    private String[] getExceptions() {
        try {
            CachedClassMirrors.ClassMirror cm = this.context.detector.classForName(this.interfaceName);
            for (CachedClassMirrors.MethodMirror m : cm.getDeclaredMethods()) {
                if (!m.getName().equals(this.methodName) || !m.getMethodDescriptor().equals(this.desc)) continue;
                String[] ret = m.getExceptionTypes();
                if (ret != null) {
                    return SAMweaver.internalName(ret);
                }
                break;
            }
        }
        catch (ClassMirrorNotFoundException classMirrorNotFoundException) {
            // empty catch block
        }
        assert (false) : "Class Mirror not found for interface " + this.interfaceName;
        return new String[0];
    }
}

