/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import java.util.ArrayList;
import java.util.List;
import kilim.analysis.BBList;
import kilim.analysis.BasicBlock;
import kilim.analysis.CallWeaver;
import kilim.analysis.ClassWeaver;
import kilim.analysis.Handler;
import kilim.analysis.MethodFlow;
import kilim.analysis.TypeDesc;
import kilim.analysis.VMType;
import kilim.analysis.ValInfoList;
import kilim.mirrors.Detector;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

public class MethodWeaver {
    private ClassWeaver classWeaver;
    private MethodFlow methodFlow;
    private boolean isPausable;
    private int maxVars;
    private int maxStack;
    private boolean isSAM;
    private int fiberVar;
    private int numWordsInSig;
    private ArrayList<CallWeaver> callWeavers = new ArrayList(5);
    private Detector detector;
    private boolean fiberIncluded;

    MethodWeaver(ClassWeaver cw, Detector detector, MethodFlow mf, boolean isSAM) {
        this.detector = detector;
        this.classWeaver = cw;
        this.methodFlow = mf;
        this.isPausable = mf.isPausable();
        this.fiberIncluded = mf.desc.contains("Lkilim/Fiber;");
        if (this.fiberIncluded) {
            this.fiberVar = this.getFiberArgVar();
            this.maxVars = this.methodFlow.maxLocals;
        } else {
            this.fiberVar = this.methodFlow.maxLocals;
            this.maxVars = this.fiberVar + 1;
        }
        this.maxStack = this.methodFlow.maxStack + 1;
        this.isSAM = isSAM;
        if (!mf.isAbstract()) {
            this.createCallWeavers();
        }
    }

    public void accept(ClassVisitor cv) {
        MethodFlow mf = this.methodFlow;
        String[] exceptions = ClassWeaver.toStringArray(mf.exceptions);
        String desc = mf.desc;
        String sig = mf.signature;
        int access = mf.access;
        if (mf.isPausable()) {
            access &= 0xFFFFFF7F;
            if (!this.isSAM & !this.fiberIncluded) {
                desc = desc.replace(")", "Lkilim/Fiber;)");
                if (sig != null) {
                    sig = sig.replace(")", "Lkilim/Fiber;)");
                }
            }
        }
        MethodVisitor mv = cv.visitMethod(access, mf.name, desc, sig, exceptions);
        if (!mf.isAbstract()) {
            if (mf.needsWeaving()) {
                this.accept(mv);
            } else {
                mf.accept(mv);
            }
        } else {
            mf.accept(mv);
        }
    }

    void accept(MethodVisitor mv) {
        this.visitAttrs(mv);
        this.visitCode(mv);
        mv.visitEnd();
    }

    private void visitAttrs(MethodVisitor mv) {
        AnnotationNode an;
        int j;
        List l;
        AnnotationNode an2;
        int i;
        MethodFlow mf = this.methodFlow;
        if (mf.annotationDefault != null) {
            AnnotationVisitor av = mv.visitAnnotationDefault();
            MethodFlow.acceptAnnotation(av, null, mf.annotationDefault);
            av.visitEnd();
        }
        int n = mf.visibleAnnotations == null ? 0 : mf.visibleAnnotations.size();
        for (i = 0; i < n; ++i) {
            an2 = (AnnotationNode)mf.visibleAnnotations.get(i);
            an2.accept(mv.visitAnnotation(an2.desc, true));
        }
        n = mf.invisibleAnnotations == null ? 0 : mf.invisibleAnnotations.size();
        for (i = 0; i < n; ++i) {
            an2 = (AnnotationNode)mf.invisibleAnnotations.get(i);
            an2.accept(mv.visitAnnotation(an2.desc, false));
        }
        n = mf.visibleParameterAnnotations == null ? 0 : mf.visibleParameterAnnotations.length;
        for (i = 0; i < n; ++i) {
            l = mf.visibleParameterAnnotations[i];
            if (l == null) continue;
            for (j = 0; j < l.size(); ++j) {
                an = (AnnotationNode)l.get(j);
                an.accept(mv.visitParameterAnnotation(i, an.desc, true));
            }
        }
        n = mf.invisibleParameterAnnotations == null ? 0 : mf.invisibleParameterAnnotations.length;
        for (i = 0; i < n; ++i) {
            l = mf.invisibleParameterAnnotations[i];
            if (l == null) continue;
            for (j = 0; j < l.size(); ++j) {
                an = (AnnotationNode)l.get(j);
                an.accept(mv.visitParameterAnnotation(i, an.desc, false));
            }
        }
        n = mf.attrs == null ? 0 : mf.attrs.size();
        for (i = 0; i < n; ++i) {
            mv.visitAttribute((Attribute)mf.attrs.get(i));
        }
    }

    private void visitCode(MethodVisitor mv) {
        mv.visitCode();
        this.methodFlow.resetLabels();
        this.visitTryCatchBlocks(mv);
        this.visitInstructions(mv);
        this.visitLocals(mv);
        this.visitLineNumbers(mv);
        mv.visitMaxs(this.maxStack, this.maxVars);
    }

    private void visitLineNumbers(MethodVisitor mv) {
        this.methodFlow.visitLineNumbers(mv);
    }

    private void visitLocals(MethodVisitor mv) {
        for (Object l : this.methodFlow.localVariables) {
            ((LocalVariableNode)l).accept(mv);
        }
    }

    private void visitInstructions(MethodVisitor mv) {
        LabelNode l;
        MethodFlow mf = this.methodFlow;
        this.genPrelude(mv);
        BasicBlock lastBB = null;
        for (BasicBlock bb : mf.getBasicBlocks()) {
            List<CallWeaver> cwList;
            int from = bb.startPos;
            if (bb.isPausable() && bb.startFrame != null) {
                this.genPausableMethod(mv, bb);
                from = bb.startPos + 1;
            } else if (bb.isCatchHandler() && (cwList = this.getCallsUnderCatchBlock(bb)) != null) {
                this.genException(mv, bb, cwList);
                from = bb.startPos + 1;
            }
            int to = bb.endPos;
            for (int i = from; i <= to; ++i) {
                AbstractInsnNode ain;
                LabelNode l2 = mf.getLabelAt(i);
                if (l2 != null) {
                    l2.accept(mv);
                }
                if ((ain = bb.getInstruction(i)).getOpcode() == 186) {
                    this.transformIndyBootstrap(mv, ain);
                    continue;
                }
                ain.accept(mv);
            }
            lastBB = bb;
        }
        if (lastBB != null && (l = this.methodFlow.getLabelAt(lastBB.endPos + 1)) != null) {
            l.accept(mv);
        }
    }

    private void transformIndyBootstrap(MethodVisitor mv, AbstractInsnNode ain) {
        InvokeDynamicInsnNode indy = (InvokeDynamicInsnNode)ain;
        Object[] bsmArgs = indy.bsmArgs;
        if (indy.bsm.getOwner().equals("java/lang/invoke/LambdaMetafactory")) {
            boolean fiber;
            Handle lambdaBody = (Handle)bsmArgs[1];
            String desc = lambdaBody.getDesc();
            boolean pausable = this.detector.isPausable(lambdaBody.getOwner(), lambdaBody.getName(), desc);
            if (pausable & !(fiber = desc.contains("Lkilim/Fiber;)"))) {
                bsmArgs[0] = MethodWeaver.addFiberType((Type)bsmArgs[0]);
                bsmArgs[1] = new Handle(lambdaBody.getTag(), lambdaBody.getOwner(), lambdaBody.getName(), desc.replace(")", "Lkilim/Fiber;)"), lambdaBody.isInterface());
                bsmArgs[2] = MethodWeaver.addFiberType((Type)bsmArgs[2]);
            }
        }
        ain.accept(mv);
    }

    private static Type addFiberType(Type type) {
        String typeDesc = type.toString().replace(")", "Lkilim/Fiber;)");
        return Type.getType((String)typeDesc);
    }

    private List<CallWeaver> getCallsUnderCatchBlock(BasicBlock catchBB) {
        ArrayList<CallWeaver> cwList = null;
        for (CallWeaver cw : this.callWeavers) {
            for (Handler h : cw.bb.handlers) {
                if (h.catchBB != catchBB) continue;
                if (cwList == null) {
                    cwList = new ArrayList<CallWeaver>(this.callWeavers.size());
                }
                if (cwList.contains(cw)) continue;
                cwList.add(cw);
            }
        }
        return cwList;
    }

    private void genPausableMethod(MethodVisitor mv, BasicBlock bb) {
        CallWeaver caw = null;
        if (bb.isGetCurrentTask()) {
            this.genGetCurrentTask(mv, bb);
            return;
        }
        for (CallWeaver cw : this.callWeavers) {
            if (cw.getBasicBlock() != bb) continue;
            caw = cw;
            break;
        }
        caw.genCall(mv);
        caw.genPostCall(mv);
    }

    void genGetCurrentTask(MethodVisitor mv, BasicBlock bb) {
        bb.startLabel.accept(mv);
        VMType.loadVar(mv, 0, this.getFiberVar());
        mv.visitFieldInsn(180, "kilim/Fiber", "task", "Lkilim/Task;");
    }

    private boolean hasGetCurrentTask() {
        MethodFlow mf = this.methodFlow;
        for (BasicBlock bb : mf.getBasicBlocks()) {
            if (!bb.isPausable() || bb.startFrame == null || !bb.isGetCurrentTask()) continue;
            return true;
        }
        return false;
    }

    private void createCallWeavers() {
        MethodFlow mf = this.methodFlow;
        for (BasicBlock bb : mf.getBasicBlocks()) {
            if (!bb.isPausable() || bb.startFrame == null || bb.isGetCurrentTask()) continue;
            CallWeaver cw = new CallWeaver(this, this.detector, bb);
            this.callWeavers.add(cw);
        }
    }

    private void genPrelude(MethodVisitor mv) {
        if (!this.methodFlow.isPausable()) {
            return;
        }
        if (this.callWeavers.size() == 0 && !this.hasGetCurrentTask()) {
            return;
        }
        MethodFlow mf = this.methodFlow;
        int lastVar = this.getFiberArgVar();
        mv.visitVarInsn(25, lastVar);
        if (lastVar < this.fiberVar) {
            if (this.callWeavers.size() > 0) {
                mv.visitInsn(89);
            }
            mv.visitVarInsn(58, this.getFiberVar());
        }
        if (this.callWeavers.size() == 0) {
            return;
        }
        mv.visitFieldInsn(180, "kilim/Fiber", "pc", "I");
        this.ensureMaxStack(2);
        LabelNode startLabel = mf.getOrCreateLabelAtPos(0);
        LabelNode errLabel = new LabelNode();
        LabelNode[] labels = new LabelNode[this.callWeavers.size() + 1];
        labels[0] = startLabel;
        for (int i = 0; i < this.callWeavers.size(); ++i) {
            labels[i + 1] = new LabelNode();
        }
        new TableSwitchInsnNode(0, this.callWeavers.size(), errLabel, labels).accept(mv);
        errLabel.accept(mv);
        mv.visitVarInsn(25, this.getFiberVar());
        mv.visitMethodInsn(182, "kilim/Fiber", "wrongPC", "()V", false);
        int last = this.callWeavers.size() - 1;
        for (int i = 0; i <= last; ++i) {
            CallWeaver cw = this.callWeavers.get(i);
            labels[i + 1].accept(mv);
            cw.genRewind(mv);
        }
        startLabel.accept(mv);
    }

    boolean isStatic() {
        return this.methodFlow.isStatic();
    }

    int getFiberArgVar() {
        return this.getNumWordsInArg() - (this.fiberIncluded ? 1 : 0);
    }

    int getNumWordsInArg() {
        int lastVar = this.getNumWordsInSig();
        if (!this.isStatic()) {
            ++lastVar;
        }
        return lastVar;
    }

    int getNumWordsInSig() {
        if (this.numWordsInSig != -1) {
            String[] args = TypeDesc.getArgumentTypes(this.methodFlow.desc);
            int size = 0;
            for (int i = 0; i < args.length; ++i) {
                size += TypeDesc.isDoubleWord(args[i]) ? 2 : 1;
            }
            this.numWordsInSig = size;
        }
        return this.numWordsInSig;
    }

    private void genException(MethodVisitor mv, BasicBlock bb, List<CallWeaver> cwList) {
        int i;
        bb.startLabel.accept(mv);
        LabelNode resumeLabel = new LabelNode();
        VMType.loadVar(mv, 0, this.getFiberVar());
        mv.visitMethodInsn(182, "kilim/Fiber", "upEx", "()I", false);
        LabelNode[] labels = new LabelNode[cwList.size()];
        int[] keys = new int[cwList.size()];
        for (i = 0; i < cwList.size(); ++i) {
            labels[i] = new LabelNode();
            keys[i] = this.callWeavers.indexOf(cwList.get(i)) + 1;
        }
        new LookupSwitchInsnNode(resumeLabel, keys, labels).accept(mv);
        i = 0;
        for (CallWeaver cw : cwList) {
            if (i > 0) {
                mv.visitJumpInsn(167, resumeLabel.getLabel());
            }
            labels[i].accept(mv);
            cw.genRestoreEx(mv, labels[i]);
            ++i;
        }
        resumeLabel.accept(mv);
        bb.getInstruction(bb.startPos).accept(mv);
    }

    int getFiberVar() {
        return this.fiberVar;
    }

    void visitTryCatchBlocks(MethodVisitor mv) {
        MethodFlow mf = this.methodFlow;
        BBList bbs = mf.getBasicBlocks();
        ArrayList<Handler> allHandlers = new ArrayList<Handler>(bbs.size() * 2);
        for (BasicBlock bb : bbs) {
            allHandlers.addAll(bb.handlers);
        }
        allHandlers = Handler.consolidate(allHandlers);
        for (Handler h : allHandlers) {
            new TryCatchBlockNode(mf.getLabelAt(h.from), mf.getOrCreateLabelAtPos(h.to + 1), h.catchBB.startLabel, h.type).accept(mv);
        }
    }

    void ensureMaxVars(int numVars) {
        if (numVars > this.maxVars) {
            this.maxVars = numVars;
        }
    }

    void ensureMaxStack(int numStack) {
        if (numStack > this.maxStack) {
            this.maxStack = numStack;
        }
    }

    int getPC(CallWeaver weaver) {
        for (int i = 0; i < this.callWeavers.size(); ++i) {
            if (this.callWeavers.get(i) != weaver) continue;
            return i + 1;
        }
        assert (false) : " No weaver found";
        return 0;
    }

    public String createStateClass(ValInfoList valInfoList) {
        return this.classWeaver.createStateClass(valInfoList);
    }

    void makeNotWovenMethod(ClassVisitor cv, MethodFlow mf, boolean isSAM) {
        boolean fiber = mf.desc.contains("Lkilim/Fiber;)");
        if (fiber) {
            return;
        }
        if (this.classWeaver.classFlow.isJava7() && this.classWeaver.isInterface()) {
            MethodVisitor mv = cv.visitMethod(mf.access, mf.name, mf.desc, mf.signature, ClassWeaver.toStringArray(mf.exceptions));
            this.visitAttrs(mv);
            mv.visitEnd();
        } else {
            int numlocals;
            int access = mf.access;
            String desc = isSAM ? mf.desc.replace(")", "Lkilim/Fiber;)") : mf.desc;
            MethodVisitor mv = cv.visitMethod(access &= 0xFFFFFBFF, mf.name, desc, mf.signature, ClassWeaver.toStringArray(mf.exceptions));
            mv.visitCode();
            this.visitAttrs(mv);
            boolean isInterface = this.classWeaver.isInterface() && !isSAM;
            mv.visitMethodInsn(184, "kilim/Task", "errNotWoven", "()V", isInterface);
            String rdesc = TypeDesc.getReturnTypeDesc(mf.desc);
            int stacksize = 0;
            if (rdesc != "V") {
                stacksize = TypeDesc.isDoubleWord(rdesc) ? 2 : 1;
                int vmt = VMType.toVmType(rdesc);
                mv.visitInsn(VMType.constInsn[vmt]);
                mv.visitInsn(VMType.retInsn[vmt]);
            } else {
                mv.visitInsn(177);
            }
            if ((mf.access & 0x400) != 0) {
                numlocals = this.getNumWordsInSig() + 1;
                if (!mf.isStatic()) {
                    ++numlocals;
                }
            } else {
                numlocals = mf.maxLocals + 1;
            }
            mv.visitMaxs(stacksize, numlocals);
            mv.visitEnd();
        }
    }

    ClassWeaver getClassWeaver() {
        return this.classWeaver;
    }

    MethodFlow getMethodFlow() {
        return this.methodFlow;
    }
}

