/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.TreeMap;
import kilim.KilimException;
import kilim.analysis.BBComparator;
import kilim.analysis.BBList;
import kilim.analysis.BasicBlock;
import kilim.analysis.ClassFlow;
import kilim.analysis.Frame;
import kilim.analysis.Handler;
import kilim.analysis.TypeDesc;
import kilim.analysis.Usage;
import kilim.mirrors.Detector;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

public class MethodFlow
extends MethodNode {
    ClassFlow classFlow;
    private ArrayList<LabelNode> posToLabelMap;
    private HashMap<LabelNode, Integer> labelToPosMap;
    private HashMap<LabelNode, BasicBlock> labelToBBMap;
    private BBList basicBlocks;
    private PriorityQueue<BasicBlock> workset;
    private boolean hasPausableAnnotation;
    private boolean suppressPausableCheck;
    private List<MethodInsnNode> pausableMethods = new LinkedList<MethodInsnNode>();
    final Detector detector;
    private TreeMap<Integer, LineNumberNode> lineNumberNodes = new TreeMap();
    private HashMap<Integer, FrameNode> frameNodes = new HashMap();
    private boolean hasPausableInvokeDynamic;
    ArrayList<Handler> origHandlers;
    private BitSet firstBorn;
    private int[] handlerMap;
    public static boolean debugPrintLiveness = false;

    public MethodFlow(ClassFlow classFlow, int access, String name, String desc, String signature, String[] exceptions, Detector detector) {
        super(458752, access, name, desc, signature, exceptions);
        this.classFlow = classFlow;
        this.detector = detector;
        this.posToLabelMap = new ArrayList();
        this.labelToPosMap = new HashMap();
        this.labelToBBMap = new HashMap();
        if (exceptions != null && exceptions.length > 0) {
            for (String e : exceptions) {
                if (e.equals("kilim/Pausable")) {
                    this.hasPausableAnnotation = true;
                    break;
                }
                if (!e.equals("kilim/NotPausable")) continue;
                this.suppressPausableCheck = true;
            }
        }
    }

    public void restoreNonInstructionNodes() {
        LineNumberNode ln;
        InsnList newinsns = new InsnList();
        int sz = this.instructions.size();
        for (int i = 0; i < sz; ++i) {
            LineNumberNode ln2;
            LabelNode l = this.getLabelAt(i);
            if (l != null) {
                newinsns.add((AbstractInsnNode)l);
            }
            if ((ln2 = this.lineNumberNodes.get(i)) != null) {
                newinsns.add((AbstractInsnNode)ln2);
            }
            AbstractInsnNode ain = this.instructions.get(i);
            newinsns.add(ain);
        }
        LabelNode l = this.getLabelAt(sz);
        if (l != null) {
            newinsns.add((AbstractInsnNode)l);
        }
        if ((ln = this.lineNumberNodes.get(sz)) != null) {
            newinsns.add((AbstractInsnNode)ln);
        }
        this.instructions = newinsns;
    }

    public void analyze() throws KilimException {
        this.preAssignCatchHandlers();
        this.buildBasicBlocks();
        if (this.basicBlocks.size() == 0) {
            return;
        }
        this.consolidateBasicBlocks();
        this.assignCatchHandlers();
        this.inlineSubroutines();
        this.doLiveVarAnalysis();
        this.dataFlow();
        this.labelToBBMap = null;
    }

    public void verifyPausables() throws KilimException {
        if (this.classFlow.isWoven || this.suppressPausableCheck) {
            return;
        }
        String methodText = this.toString(this.classFlow.getClassName(), this.name, this.desc);
        boolean ctor = this.name.endsWith("init>");
        if (ctor & this.hasPausableAnnotation) {
            throw new KilimException("Constructors cannot be declared Pausable: " + methodText + "\n");
        }
        if (!this.hasPausableAnnotation && !this.pausableMethods.isEmpty()) {
            String msg = ctor ? "Constructor " + methodText + " illegally calls pausable methods:\n" : methodText + " should be marked pausable. It calls pausable methods\n";
            for (MethodInsnNode min : this.pausableMethods) {
                msg = msg + this.toString(min.owner, min.name, min.desc) + '\n';
            }
            throw new KilimException(msg);
        }
        if (this.classFlow.superName != null) {
            this.checkStatus(this.classFlow.superName, this.name, this.desc);
        }
        if (this.classFlow.interfaces != null) {
            for (Object ifc : this.classFlow.interfaces) {
                this.checkStatus((String)ifc, this.name, this.desc);
            }
        }
    }

    private void checkStatus(String superClassName, String methodName, String desc) throws KilimException {
        int status = this.detector.getPausableStatus(superClassName, methodName, desc);
        if (status == 1 && !this.hasPausableAnnotation) {
            throw new KilimException("Base class method is pausable, derived class is not: \nBase class = " + superClassName + "\nDerived class = " + this.classFlow.name + "\nMethod = " + methodName + desc);
        }
        if (status == 2 && this.hasPausableAnnotation) {
            throw new KilimException("Base class method is not pausable, but derived class is: \nBase class = " + superClassName + "\nDerived class = " + this.classFlow.name + "\nMethod = " + methodName + desc);
        }
    }

    private String toString(String className, String methName, String desc) {
        return className.replace('/', '.') + '.' + methName + desc;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        int methodStatus;
        super.visitMethodInsn(opcode, owner, name, desc, itf);
        if (!this.classFlow.isWoven && (methodStatus = this.detector.getPausableStatus(owner, name, desc)) == 1) {
            MethodInsnNode min = (MethodInsnNode)this.instructions.get(this.instructions.size() - 1);
            this.pausableMethods.add(min);
        }
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        if (!this.classFlow.isWoven && bsm.getOwner().equals("java/lang/invoke/LambdaMetafactory")) {
            Handle lambdaBody = (Handle)bsmArgs[1];
            String lambdaDesc = lambdaBody.getDesc();
            if (this.detector.isPausable(lambdaBody.getOwner(), lambdaBody.getName(), lambdaDesc)) {
                this.hasPausableInvokeDynamic = true;
            }
        }
        super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
    }

    public void visitLabel(Label label) {
        this.setLabel(this.instructions.size(), super.getLabelNode(label));
    }

    public void visitLineNumber(int line, Label start) {
        LabelNode ln = this.getLabelNode(start);
        this.lineNumberNodes.put(this.instructions.size(), new LineNumberNode(line, ln));
    }

    void visitLineNumbers(MethodVisitor mv) {
        for (LineNumberNode node : this.lineNumberNodes.values()) {
            mv.visitLineNumber(node.line, node.start.getLabel());
        }
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        this.frameNodes.put(this.instructions.size(), new FrameNode(type, nLocal, local, nStack, stack));
    }

    private void inlineSubroutines() throws KilimException {
        this.markPausableJSRs();
        block0: while (true) {
            ArrayList<BasicBlock> newBBs = null;
            for (BasicBlock bb : this.basicBlocks) {
                if (bb.hasFlag(128)) continue;
                bb.setFlag(128);
                if (bb.lastInstruction() != 168 || (newBBs = bb.inline()) == null) continue;
                break;
            }
            if (newBBs == null) break;
            int id = this.basicBlocks.size();
            Iterator iterator = newBBs.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                BasicBlock bb = (BasicBlock)iterator.next();
                bb.setId(id++);
                this.basicBlocks.add(bb);
            }
            break;
        }
        for (BasicBlock bb : this.basicBlocks) {
            bb.changeJSR_RET_toGOTOs();
        }
    }

    private void markPausableJSRs() throws KilimException {
        for (BasicBlock bb : this.basicBlocks) {
            bb.checkPausableJSR();
        }
    }

    boolean isPausableMethodInsn(MethodInsnNode min) {
        return this.pausableMethods.contains(min);
    }

    public String toString() {
        BBList ret = this.getBasicBlocks();
        Collections.sort(ret);
        return ret.toString();
    }

    public BBList getBasicBlocks() {
        return this.basicBlocks;
    }

    private void preAssignCatchHandlers() {
        ArrayList tcbs = (ArrayList)this.tryCatchBlocks;
        if (tcbs.size() == 0) {
            return;
        }
        ArrayList<Handler> handlers = new ArrayList<Handler>(tcbs.size());
        for (int i = 0; i < tcbs.size(); ++i) {
            TryCatchBlockNode tcb = (TryCatchBlockNode)tcbs.get(i);
            handlers.add(new Handler(this.getLabelPosition(tcb.start), this.getLabelPosition(tcb.end) - 1, tcb.type, this.getOrCreateBasicBlock(tcb.handler)));
        }
        Collections.sort(handlers, Handler.startComparator());
        this.origHandlers = handlers;
        this.buildHandlerMap();
    }

    private void assignCatchHandlers() {
        if (this.origHandlers == null) {
            return;
        }
        for (BasicBlock bb : this.basicBlocks) {
            bb.chooseCatchHandlers(this.origHandlers);
        }
        this.origHandlers = null;
        this.handlerMap = null;
    }

    private void buildHandlerMap() {
        int ki;
        this.handlerMap = new int[this.instructions.size()];
        for (ki = 0; ki < this.handlerMap.length; ++ki) {
            this.handlerMap[ki] = -1;
        }
        ki = 0;
        for (int kh = 0; kh < this.origHandlers.size(); ++kh) {
            Handler ho = this.origHandlers.get(kh);
            while (ki <= ho.from) {
                this.handlerMap[ki] = kh;
                ++ki;
            }
        }
    }

    int mapHandler(int start) {
        if (this.handlerMap == null || start >= this.handlerMap.length) {
            return -1;
        }
        int map = this.handlerMap[start];
        return map < 0 ? -1 : this.origHandlers.get((int)map).from;
    }

    void buildBasicBlocks() {
        int numInstructions = this.instructions.size();
        this.basicBlocks = new BBList();
        for (int i = 0; i < numInstructions; ++i) {
            LabelNode l = this.getOrCreateLabelAtPos(i);
            BasicBlock bb = this.getOrCreateBasicBlock(l);
            i = bb.initialize(i);
            this.basicBlocks.add(bb);
        }
    }

    private boolean calcBornOnce() {
        BBList bbs = this.getBasicBlocks();
        LinkedList pending = new LinkedList();
        boolean changed = false;
        boolean first = true;
        pending.add(bbs.get(0));
        ((BasicBlock)bbs.get((int)0)).usage.evalBornIn(null, new BitSet());
        while (!pending.isEmpty()) {
            BasicBlock bb = (BasicBlock)pending.pop();
            if (bb.visited) continue;
            bb.visited = true;
            for (Handler ho : bb.handlers) {
                changed |= ho.catchBB.usage.evalBornIn(bb.usage, null);
                pending.addFirst(ho.catchBB);
            }
            BitSet combo = bb.usage.getCombo();
            if (first) {
                combo.or(this.firstBorn);
            }
            for (BasicBlock so : bb.successors) {
                changed |= so.usage.evalBornIn(bb.usage, combo);
                pending.addFirst(so);
            }
            first = false;
        }
        return changed;
    }

    private void calcBornUsage() {
        while (this.calcBornOnce()) {
        }
        ((BasicBlock)this.getBasicBlocks().get((int)0)).usage.initBorn(this.firstBorn);
        for (BasicBlock bb : this.getBasicBlocks()) {
            bb.usage.mergeBorn();
        }
    }

    private void doLiveVarAnalysis() {
        boolean changed;
        BBList bbs = this.getBasicBlocks();
        Collections.sort(bbs);
        this.firstBorn = this.setArgsBorn((BasicBlock)bbs.get(0));
        this.calcBornUsage();
        do {
            changed = false;
            for (int i = bbs.size() - 1; i >= 0; --i) {
                changed = ((BasicBlock)bbs.get(i)).flowVarUsage() || changed;
            }
        } while (changed);
        if (debugPrintLiveness) {
            this.printUsage(bbs);
        }
    }

    private BitSet setArgsBorn(BasicBlock bb) {
        BitSet born = new BitSet(bb.flow.maxLocals);
        int offset = 0;
        if (!this.isStatic()) {
            born.set(offset++);
        }
        for (String arg : TypeDesc.getArgumentTypes(this.desc)) {
            born.set(offset);
            offset += TypeDesc.isDoubleWord(arg) ? 2 : 1;
        }
        return born;
    }

    void printUsage(ArrayList<BasicBlock> bbs) {
        System.out.println(this.name);
        if (bbs == null) {
            bbs = this.getBasicBlocks();
        }
        for (BasicBlock bb : bbs) {
            Usage uu = bb.usage;
            String range = String.format("%4d %4d: ", bb.startPos, bb.endPos);
            System.out.print(range + uu.toStringBits("  "));
            System.out.println(" -- " + bb.printGeniology());
        }
        System.out.format("\n\n", new Object[0]);
    }

    private void consolidateBasicBlocks() {
        BBList newBBs = new BBList(this.basicBlocks.size());
        int pos = 0;
        for (BasicBlock bb : this.basicBlocks) {
            if (bb.hasFlag(4)) continue;
            bb.coalesceTrivialFollowers();
            bb.setId(pos++);
            newBBs.add(bb);
        }
        this.basicBlocks = newBBs;
        assert (this.checkNoBasicBlockLeftBehind());
    }

    private boolean checkNoBasicBlockLeftBehind() {
        BBList bbs = this.basicBlocks;
        HashSet<BasicBlock> hs = new HashSet<BasicBlock>(bbs.size() * 2);
        hs.addAll(bbs);
        int prevBBend = -1;
        for (BasicBlock bb : bbs) {
            assert (bb.isInitialized()) : "BB not inited: " + bb;
            assert (bb.startPos == prevBBend + 1);
            for (BasicBlock succ : bb.successors) {
                assert (succ.isInitialized()) : "Basic block not inited: " + succ + "\nSuccessor of " + bb;
                assert (hs.contains(succ)) : "BB not found:\n" + succ;
            }
            prevBBend = bb.endPos;
        }
        assert (((BasicBlock)bbs.get((int)(bbs.size() - 1))).endPos == this.instructions.size() - 1);
        return true;
    }

    private void dataFlow() {
        this.workset = new PriorityQueue<BasicBlock>(this.instructions.size(), new BBComparator());
        BasicBlock startBB = (BasicBlock)this.getBasicBlocks().get(0);
        assert (startBB != null) : "Null starting block in flowTypes()";
        startBB.startFrame = new Frame(this.classFlow.getClassDescriptor(), this);
        this.enqueue(startBB);
        while (!this.workset.isEmpty()) {
            BasicBlock bb = this.dequeue();
            bb.interpret();
        }
    }

    void setLabel(int pos, LabelNode l) {
        for (int i = pos - this.posToLabelMap.size() + 1; i >= 0; --i) {
            this.posToLabelMap.add(null);
        }
        this.posToLabelMap.set(pos, l);
        this.labelToPosMap.put(l, pos);
    }

    LabelNode getOrCreateLabelAtPos(int pos) {
        LabelNode ret = null;
        if (pos < this.posToLabelMap.size()) {
            ret = this.posToLabelMap.get(pos);
        }
        if (ret == null) {
            ret = new LabelNode();
            this.setLabel(pos, ret);
        }
        return ret;
    }

    int getLabelPosition(LabelNode l) {
        return this.labelToPosMap.get(l);
    }

    BasicBlock getOrCreateBasicBlock(LabelNode l) {
        BasicBlock ret = this.labelToBBMap.get(l);
        if (ret == null) {
            ret = new BasicBlock(this, l);
            BasicBlock oldVal = this.labelToBBMap.put(l, ret);
            assert (oldVal == null) : "Duplicate BB created at label";
        }
        return ret;
    }

    BasicBlock getBasicBlock(LabelNode l) {
        return this.labelToBBMap.get(l);
    }

    private BasicBlock dequeue() {
        BasicBlock bb = this.workset.poll();
        bb.unsetFlag(1);
        return bb;
    }

    void enqueue(BasicBlock bb) {
        assert (bb.startFrame != null) : "Enqueued null start frame";
        if (!bb.hasFlag(1)) {
            this.workset.add(bb);
            bb.setFlag(1);
        }
    }

    public LabelNode getLabelAt(int pos) {
        return pos < this.posToLabelMap.size() ? this.posToLabelMap.get(pos) : null;
    }

    void addInlinedBlock(BasicBlock bb) {
        bb.setId(this.basicBlocks.size());
        this.basicBlocks.add(bb);
    }

    public int getNumArgs() {
        int ret = TypeDesc.getNumArgumentTypes(this.desc);
        if (!this.isStatic()) {
            ++ret;
        }
        return ret;
    }

    public boolean isPausable() {
        return this.hasPausableAnnotation;
    }

    public void setPausable(boolean isPausable) {
        this.hasPausableAnnotation = isPausable;
    }

    public static void acceptAnnotation(AnnotationVisitor av, String name, Object value) {
        if (value instanceof String[]) {
            String[] typeconst = (String[])value;
            av.visitEnum(name, typeconst[0], typeconst[1]);
        } else if (value instanceof AnnotationNode) {
            AnnotationNode an = (AnnotationNode)value;
            an.accept(av.visitAnnotation(name, an.desc));
        } else if (value instanceof List) {
            AnnotationVisitor v = av.visitArray(name);
            List array = (List)value;
            for (int j = 0; j < array.size(); ++j) {
                MethodFlow.acceptAnnotation(v, null, array.get(j));
            }
            v.visitEnd();
        } else {
            av.visit(name, value);
        }
    }

    public boolean isAbstract() {
        return (this.access & 0x400) != 0;
    }

    public boolean isStatic() {
        return (this.access & 8) != 0;
    }

    public boolean isBridge() {
        return (this.access & 0x40) != 0;
    }

    public void resetLabels() {
        for (int i = 0; i < this.posToLabelMap.size(); ++i) {
            LabelNode ln = this.posToLabelMap.get(i);
            if (ln == null) continue;
            ln.resetLabel();
        }
    }

    boolean needsWeaving() {
        return this.isPausable() || this.hasPausableInvokeDynamic;
    }
}

