/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kilim.analysis.FileContainer;
import kilim.analysis.FileLister;

class JarIterator
extends FileContainer {
    Enumeration<JarEntry> jarEnum;
    JarFile jarFile;
    String nextName;

    JarIterator(JarFile f) {
        this.jarFile = f;
        this.jarEnum = f.entries();
    }

    @Override
    public boolean hasNext() {
        return this.jarEnum.hasMoreElements();
    }

    @Override
    public FileLister.Entry next() {
        return new JEntry(this.jarEnum.nextElement());
    }

    @Override
    public void remove() {
        throw new RuntimeException("FileLister does not remove files");
    }

    @Override
    FileLister.Entry open(String relativeFileName) throws IOException {
        JarEntry e = this.jarFile.getJarEntry(relativeFileName);
        return e == null ? null : new JEntry(e);
    }

    private class JEntry
    extends FileLister.Entry {
        private final JarEntry jarEntry;

        JEntry(JarEntry j) {
            this.jarEntry = j;
        }

        @Override
        public String getFileName() {
            return this.jarEntry.getName();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return JarIterator.this.jarFile.getInputStream(this.jarEntry);
        }

        @Override
        public long getSize() {
            return this.jarEntry.getSize();
        }
    }
}

