/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Stack;
import kilim.analysis.FileContainer;
import kilim.analysis.FileLister;

class DirIterator
extends FileContainer {
    final File root;
    String rootpath;
    Stack<File> stack = new Stack();

    DirIterator(File f) {
        this.root = f;
        this.rootpath = this.root.getPath();
        this.stack.push(f);
    }

    @Override
    public boolean hasNext() {
        return !this.stack.isEmpty();
    }

    @Override
    public FileLister.Entry next() {
        File ret = this.stack.pop();
        if (ret.isDirectory()) {
            File ff;
            int i;
            File[] files = ret.listFiles();
            for (i = files.length - 1; i >= 0; --i) {
                ff = files[i];
                if (!ff.isDirectory()) continue;
                this.stack.push(ff);
            }
            for (i = files.length - 1; i >= 0; --i) {
                ff = files[i];
                if (ff.isDirectory()) continue;
                this.stack.push(ff);
            }
        }
        return new DirEntry(ret);
    }

    @Override
    public void remove() {
        throw new RuntimeException("FileLister does not remove files");
    }

    @Override
    FileLister.Entry open(String fileName) throws IOException {
        File ret = new File(this.root.getAbsolutePath() + File.separatorChar + fileName);
        if (ret.exists() && ret.isFile()) {
            return new DirEntry(ret);
        }
        return null;
    }

    private class DirEntry
    extends FileLister.Entry {
        final File file;

        DirEntry(File f) {
            this.file = f;
        }

        @Override
        public long getSize() {
            return this.file.length();
        }

        @Override
        public String getFileName() {
            return this.file.getPath();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.file));
        }

        @Override
        public boolean check(String outdir) {
            String name = this.getFileName();
            if (DirIterator.this.rootpath == null || !name.startsWith(DirIterator.this.rootpath)) {
                return false;
            }
            String relative = name.substring(DirIterator.this.rootpath.length());
            File outfile = Paths.get(outdir, relative).toFile();
            return outfile.lastModified() > this.file.lastModified();
        }
    }
}

