/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import kilim.KilimException;
import kilim.analysis.Frame;
import kilim.analysis.Handler;
import kilim.analysis.MethodFlow;
import kilim.analysis.NopInsn;
import kilim.analysis.Range;
import kilim.analysis.TypeDesc;
import kilim.analysis.Usage;
import kilim.analysis.Value;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class BasicBlock
implements Comparable<BasicBlock> {
    public int id;
    int flags;
    static final int ENQUEUED = 1;
    static final int SUBROUTINE_CLAIMED = 2;
    static final int COALESCED = 4;
    static final int PAUSABLE = 16;
    static final int IS_SUBROUTINE = 32;
    static final int SUB_BLOCK = 64;
    static final int INLINE_CHECKED = 128;
    static final int PAUSABLE_SUB = 256;
    public MethodFlow flow;
    public LabelNode startLabel;
    public int startPos = -1;
    public int endPos = -1;
    public ArrayList<BasicBlock> successors = new ArrayList(3);
    public ArrayList<Handler> handlers = new ArrayList(2);
    int numPredecessors;
    public Usage usage;
    boolean visited;
    ArrayList<Usage> succUsage;
    ArrayList<Usage> handUsage;
    public Frame startFrame;
    String caughtExceptionType;
    BasicBlock follower;
    ArrayList<BasicBlock> subBlocks;

    public BasicBlock(MethodFlow aflow, LabelNode aStartLabel) {
        this.flow = aflow;
        this.startLabel = aStartLabel;
        this.usage = new Usage(aflow.maxLocals);
        this.successors = new ArrayList(2);
    }

    int initialize(int pos) {
        BasicBlock bb;
        this.startPos = pos;
        boolean endOfBB = false;
        boolean hasFollower = true;
        int nextCatch = this.flow.mapHandler(pos + 1);
        int size = this.flow.instructions.size();
        while (pos < size) {
            if (pos > this.startPos && (pos == nextCatch || this.flow.getLabelAt(pos) != null)) {
                --pos;
                hasFollower = true;
                endOfBB = true;
                break;
            }
            AbstractInsnNode ain = this.getInstruction(pos);
            int opcode = ain.getOpcode();
            switch (opcode) {
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    this.usage.read(((VarInsnNode)ain).var);
                    break;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    this.usage.write(((VarInsnNode)ain).var);
                    break;
                }
                case 132: {
                    int v = ((IincInsnNode)ain).var;
                    this.usage.read(v);
                    this.usage.write(v);
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    LabelNode l = ((JumpInsnNode)ain).label;
                    bb = this.flow.getOrCreateBasicBlock(l);
                    if (opcode == 168) {
                        bb.setFlag(32);
                        hasFollower = false;
                    }
                    this.addSuccessor(bb);
                    if (opcode == 167) {
                        hasFollower = false;
                    }
                    endOfBB = true;
                    break;
                }
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    hasFollower = false;
                    endOfBB = true;
                    break;
                }
                case 170: 
                case 171: {
                    List otherLabels;
                    LabelNode defaultLabel;
                    if (opcode == 170) {
                        defaultLabel = ((TableSwitchInsnNode)ain).dflt;
                        otherLabels = ((TableSwitchInsnNode)ain).labels;
                    } else {
                        defaultLabel = ((LookupSwitchInsnNode)ain).dflt;
                        otherLabels = ((LookupSwitchInsnNode)ain).labels;
                    }
                    for (LabelNode l : otherLabels) {
                        this.addSuccessor(this.flow.getOrCreateBasicBlock(l));
                    }
                    this.addSuccessor(this.flow.getOrCreateBasicBlock(defaultLabel));
                    endOfBB = true;
                    hasFollower = false;
                    break;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    if (!this.flow.isPausableMethodInsn((MethodInsnNode)ain)) break;
                    LabelNode il = this.flow.getOrCreateLabelAtPos(pos);
                    if (pos == this.startPos) {
                        this.setFlag(16);
                        endOfBB = true;
                        break;
                    }
                    bb = this.flow.getOrCreateBasicBlock(il);
                    bb.setFlag(16);
                    this.addSuccessor(bb);
                    --pos;
                    hasFollower = true;
                    endOfBB = true;
                    break;
                }
                default: {
                    if (opcode < 26 || opcode > 45) break;
                    throw new IllegalStateException("instruction variants not expected here");
                }
            }
            if (endOfBB) break;
            ++pos;
        }
        this.endPos = pos;
        if (hasFollower && pos + 1 < this.flow.instructions.size()) {
            LabelNode l = this.flow.getOrCreateLabelAtPos(pos + 1);
            bb = this.flow.getOrCreateBasicBlock(l);
            this.addFollower(bb);
        }
        return pos;
    }

    void addFollower(BasicBlock bb) {
        this.follower = bb;
        this.addSuccessor(bb);
    }

    void addSuccessor(BasicBlock bb) {
        if (!this.successors.contains(bb)) {
            this.successors.add(bb);
            ++bb.numPredecessors;
        }
    }

    public Usage getVarUsage() {
        return this.usage;
    }

    int lastInstruction() {
        AbstractInsnNode ainode = this.getInstruction(this.endPos);
        return ainode.getOpcode();
    }

    void coalesceTrivialFollowers() {
        while (this.successors.size() == 1) {
            boolean isTry;
            BasicBlock succ = this.successors.get(0);
            int nextCatch = this.flow.mapHandler(succ.startPos);
            boolean bl = isTry = nextCatch == succ.startPos;
            if (succ.numPredecessors != 1 || this.lastInstruction() == 167 || this.lastInstruction() == 168 || succ.isPausable() || this.isPausable() || isTry) break;
            this.successors = succ.successors;
            this.follower = succ.follower;
            this.usage.absorb(succ.usage);
            this.endPos = succ.endPos;
            succ.setFlag(4);
        }
    }

    public void setFlag(int bitFlag) {
        this.flags |= bitFlag;
    }

    public void unsetFlag(int bitFlag) {
        this.flags &= ~bitFlag;
    }

    public boolean hasFlag(int bitFlag) {
        return (this.flags & bitFlag) != 0;
    }

    @Override
    public int compareTo(BasicBlock o) {
        if (this.id == o.id) {
            assert (this == o);
            return 0;
        }
        return this.id < o.id ? -1 : 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void interpret() {
        Frame frame = this.startFrame.dup();
        if (this.isCatchHandler()) {
            frame.clearStack();
            frame.push(Value.make(this.startPos, this.caughtExceptionType));
        } else if (this.hasFlag(32)) {
            frame.push(Value.make(this.startPos, "A"));
        }
        String componentType = null;
        boolean canThrowException = false;
        boolean propagateFrame = true;
        int i = 0;
        try {
            block69: for (i = this.startPos; i <= this.endPos; ++i) {
                AbstractInsnNode ain = this.getInstruction(i);
                int opcode = ain.getOpcode();
                switch (opcode) {
                    case -1: {
                        continue block69;
                    }
                    case 0: {
                        continue block69;
                    }
                    case 1: {
                        frame.push(Value.make(i, "NULL"));
                        continue block69;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        frame.push(Value.make(i, "I", new Integer(opcode - 3)));
                        continue block69;
                    }
                    case 9: 
                    case 10: {
                        frame.push(Value.make(i, "J", new Long(opcode - 9)));
                        continue block69;
                    }
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        int var = ((VarInsnNode)ain).var;
                        Value v = frame.getLocal(var, opcode);
                        frame.push(v);
                        continue block69;
                    }
                    case 11: 
                    case 12: 
                    case 13: {
                        frame.push(Value.make(i, "F", new Float(opcode - 11)));
                        continue block69;
                    }
                    case 14: 
                    case 15: {
                        frame.push(Value.make(i, "D", new Double(opcode - 14)));
                        continue block69;
                    }
                    case 16: {
                        int val = ((IntInsnNode)ain).operand;
                        frame.push(Value.make(i, "B", new Integer(val)));
                        continue block69;
                    }
                    case 17: {
                        int val = ((IntInsnNode)ain).operand;
                        frame.push(Value.make(i, "S", new Integer(val)));
                        continue block69;
                    }
                    case 18: {
                        Object cval = ((LdcInsnNode)ain).cst;
                        frame.push(Value.make(i, TypeDesc.getTypeDesc(cval), cval));
                        continue block69;
                    }
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: {
                        canThrowException = true;
                        frame.popWord();
                        Value v = frame.popWord();
                        frame.push(Value.make(i, TypeDesc.getComponentType(v.getTypeDesc())));
                        continue block69;
                    }
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: {
                        Value v1 = frame.pop();
                        int var = ((VarInsnNode)ain).var;
                        frame.setLocal(var, v1);
                        continue block69;
                    }
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: {
                        canThrowException = true;
                        frame.popn(3);
                        continue block69;
                    }
                    case 87: {
                        frame.popWord();
                        continue block69;
                    }
                    case 88: {
                        if (!frame.pop().isCategory1()) continue block69;
                        frame.popWord();
                        continue block69;
                    }
                    case 89: {
                        Value v = frame.popWord();
                        frame.push(v);
                        frame.push(v);
                        continue block69;
                    }
                    case 90: {
                        Value v1 = frame.popWord();
                        Value v2 = frame.popWord();
                        frame.push(v1);
                        frame.push(v2);
                        frame.push(v1);
                        continue block69;
                    }
                    case 91: {
                        Value v3;
                        Value v1 = frame.popWord();
                        Value v2 = frame.pop();
                        if (v2.isCategory1()) {
                            v3 = frame.pop();
                            if (!v3.isCategory1()) throw new InternalError("Illegal use of DUP_X2");
                            frame.push(v1);
                            frame.push(v3);
                            frame.push(v2);
                            frame.push(v1);
                            continue block69;
                        }
                        frame.push(v1);
                        frame.push(v2);
                        frame.push(v1);
                        continue block69;
                    }
                    case 92: {
                        Value v2;
                        Value v1 = frame.pop();
                        if (v1.isCategory1()) {
                            v2 = frame.pop();
                            if (!v2.isCategory1()) throw new InternalError("Illegal use of DUP2");
                            frame.push(v2);
                            frame.push(v1);
                            frame.push(v2);
                            frame.push(v1);
                            continue block69;
                        }
                        frame.push(v1);
                        frame.push(v1);
                        continue block69;
                    }
                    case 93: {
                        Value v3;
                        Value v2;
                        Value v1 = frame.pop();
                        if (v1.isCategory1()) {
                            v2 = frame.pop();
                            if (!v2.isCategory1()) throw new InternalError("Illegal use of DUP2_X1");
                            v3 = frame.popWord();
                            frame.push(v2);
                            frame.push(v1);
                            frame.push(v3);
                            frame.push(v2);
                            frame.push(v1);
                            continue block69;
                        }
                        v2 = frame.popWord();
                        frame.push(v1);
                        frame.push(v2);
                        frame.push(v1);
                        continue block69;
                    }
                    case 94: {
                        Value v3;
                        Value v2;
                        Value v1 = frame.pop();
                        if (v1.isCategory1()) {
                            v2 = frame.pop();
                            if (!v2.isCategory1()) throw new InternalError("Illegal use of DUP2_X2");
                            v3 = frame.pop();
                            if (v3.isCategory1()) {
                                Value v4 = frame.pop();
                                if (!v4.isCategory1()) throw new InternalError("Illegal use of DUP2_X2");
                                frame.push(v2);
                                frame.push(v1);
                                frame.push(v4);
                                frame.push(v3);
                                frame.push(v2);
                                frame.push(v1);
                                continue block69;
                            }
                            frame.push(v2);
                            frame.push(v1);
                            frame.push(v3);
                            frame.push(v2);
                            frame.push(v1);
                            continue block69;
                        }
                        v2 = frame.pop();
                        if (v2.isCategory1()) {
                            v3 = frame.pop();
                            if (!v3.isCategory1()) throw new InternalError("Illegal use of DUP2_X2");
                            frame.push(v1);
                            frame.push(v3);
                            frame.push(v2);
                            frame.push(v1);
                            continue block69;
                        }
                        frame.push(v1);
                        frame.push(v2);
                        frame.push(v1);
                        continue block69;
                    }
                    case 95: {
                        Value v1 = frame.popWord();
                        Value v2 = frame.popWord();
                        frame.push(v1);
                        frame.push(v2);
                        continue block69;
                    }
                    case 108: 
                    case 109: 
                    case 112: 
                    case 113: {
                        frame.pop();
                        canThrowException = true;
                        continue block69;
                    }
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 110: 
                    case 111: 
                    case 114: 
                    case 115: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 131: {
                        frame.pop();
                        Value v = frame.pop();
                        frame.push(Value.make(i, v.getTypeDesc()));
                        continue block69;
                    }
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: {
                        frame.popn(2);
                        frame.push(Value.make(i, "I"));
                        continue block69;
                    }
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: {
                        Value v = frame.pop();
                        frame.push(Value.make(i, v.getTypeDesc()));
                        continue block69;
                    }
                    case 132: {
                        int var = ((IincInsnNode)ain).var;
                        frame.setLocal(var, Value.make(i, "I"));
                        continue block69;
                    }
                    case 133: 
                    case 140: 
                    case 143: {
                        frame.pop();
                        frame.push(Value.make(i, "J"));
                        continue block69;
                    }
                    case 135: 
                    case 138: 
                    case 141: {
                        frame.pop();
                        frame.push(Value.make(i, "D"));
                        continue block69;
                    }
                    case 134: 
                    case 137: 
                    case 144: {
                        frame.pop();
                        frame.push(Value.make(i, "F"));
                        continue block69;
                    }
                    case 136: 
                    case 139: 
                    case 142: {
                        frame.pop();
                        frame.push(Value.make(i, "I"));
                        continue block69;
                    }
                    case 145: {
                        frame.popWord();
                        frame.push(Value.make(i, "Z"));
                        continue block69;
                    }
                    case 146: {
                        frame.popWord();
                        frame.push(Value.make(i, "C"));
                        continue block69;
                    }
                    case 147: {
                        frame.popWord();
                        frame.push(Value.make(i, "S"));
                        continue block69;
                    }
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 198: 
                    case 199: {
                        frame.popWord();
                        continue block69;
                    }
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: {
                        frame.popn(2);
                        continue block69;
                    }
                    case 167: 
                    case 168: 
                    case 169: {
                        continue block69;
                    }
                    case 170: 
                    case 171: {
                        frame.pop();
                        continue block69;
                    }
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: {
                        canThrowException = true;
                        if (opcode != 177) {
                            frame.pop();
                        }
                        if (frame.stacklen == 0) continue block69;
                        throw new InternalError("stack non null at method return");
                    }
                    case 178: {
                        canThrowException = true;
                        Value v = Value.make(i, TypeDesc.getInterned(((FieldInsnNode)ain).desc));
                        frame.push(v);
                        continue block69;
                    }
                    case 179: {
                        canThrowException = true;
                        frame.pop();
                        continue block69;
                    }
                    case 180: {
                        canThrowException = true;
                        Value v1 = frame.pop();
                        Value v = Value.make(i, TypeDesc.getInterned(((FieldInsnNode)ain).desc));
                        frame.push(v);
                        continue block69;
                    }
                    case 181: {
                        canThrowException = true;
                        Value v1 = frame.pop();
                        Value v = frame.pop();
                        continue block69;
                    }
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: {
                        Value v;
                        MethodInsnNode min = (MethodInsnNode)ain;
                        String desc = min.desc;
                        if (this.flow.isPausableMethodInsn(min) && frame.numMonitorsActive > 0) {
                            throw new KilimException("Error: Can not call pausable nethods from within a synchronized block\nCaller: " + this.flow.classFlow.name.replace('/', '.') + "." + this.flow.name + this.flow.desc + "\nCallee: " + ((MethodInsnNode)ain).name);
                        }
                        canThrowException = true;
                        frame.popn(TypeDesc.getNumArgumentTypes(desc));
                        if (opcode != 184) {
                            v = frame.pop();
                        }
                        if ((desc = TypeDesc.getReturnTypeDesc(desc)) == "V") continue block69;
                        frame.push(Value.make(i, desc));
                        continue block69;
                    }
                    case 186: {
                        InvokeDynamicInsnNode indy = (InvokeDynamicInsnNode)ain;
                        String desc = indy.desc;
                        frame.popn(TypeDesc.getNumArgumentTypes(desc));
                        desc = TypeDesc.getReturnTypeDesc(desc);
                        assert (desc != "V") : "InvokeDynamic return value should be a functional interface";
                        frame.push(Value.make(i, desc));
                        continue block69;
                    }
                    case 187: {
                        canThrowException = true;
                        Value v = Value.make(i, TypeDesc.getInterned(((TypeInsnNode)ain).desc));
                        frame.push(v);
                        continue block69;
                    }
                    case 188: {
                        String t;
                        canThrowException = true;
                        frame.popWord();
                        int atype = ((IntInsnNode)ain).operand;
                        switch (atype) {
                            case 4: {
                                t = "[Z";
                                break;
                            }
                            case 5: {
                                t = "[C";
                                break;
                            }
                            case 6: {
                                t = "[F";
                                break;
                            }
                            case 7: {
                                t = "[D";
                                break;
                            }
                            case 8: {
                                t = "[B";
                                break;
                            }
                            case 9: {
                                t = "[S";
                                break;
                            }
                            case 10: {
                                t = "[I";
                                break;
                            }
                            case 11: {
                                t = "[J";
                                break;
                            }
                            default: {
                                throw new InternalError("Illegal argument to NEWARRAY: " + atype);
                            }
                        }
                        frame.push(Value.make(i, t));
                        continue block69;
                    }
                    case 189: {
                        canThrowException = true;
                        frame.popWord();
                        componentType = TypeDesc.getInterned(((TypeInsnNode)ain).desc);
                        Value v = Value.make(i, TypeDesc.getInterned("[" + componentType));
                        frame.push(v);
                        continue block69;
                    }
                    case 190: {
                        canThrowException = true;
                        frame.popWord();
                        frame.push(Value.make(i, "I"));
                        continue block69;
                    }
                    case 191: {
                        canThrowException = true;
                        frame.pop();
                        propagateFrame = false;
                        continue block69;
                    }
                    case 192: {
                        canThrowException = true;
                        frame.pop();
                        Value v = Value.make(i, TypeDesc.getInterned(((TypeInsnNode)ain).desc));
                        frame.push(v);
                        continue block69;
                    }
                    case 193: {
                        canThrowException = true;
                        frame.pop();
                        frame.push(Value.make(i, "I"));
                        continue block69;
                    }
                    case 194: 
                    case 195: {
                        frame.numMonitorsActive = opcode == 194 ? ++frame.numMonitorsActive : --frame.numMonitorsActive;
                        canThrowException = true;
                        frame.pop();
                        canThrowException = true;
                        continue block69;
                    }
                    case 197: {
                        MultiANewArrayInsnNode minode = (MultiANewArrayInsnNode)ain;
                        int dims = minode.dims;
                        frame.popn(dims);
                        componentType = TypeDesc.getInterned(minode.desc);
                        StringBuffer sb = new StringBuffer(componentType.length() + dims);
                        for (int j = 0; j < dims; ++j) {
                            sb.append('[');
                        }
                        sb.append(componentType);
                        Value v = Value.make(i, TypeDesc.getInterned(sb.toString()));
                        frame.push(v);
                        continue block69;
                    }
                    default: {
                        assert (false) : "Unexpected opcode: " + ain.getOpcode();
                        continue block69;
                    }
                }
            }
            i = -1;
            if (propagateFrame) {
                this.mergeSuccessors(frame);
            }
            if (this.handlers == null) return;
            for (Handler handler : this.handlers) {
                handler.catchBB.merge(frame, true);
            }
            return;
        }
        catch (AssertionError ae) {
            System.err.println("**** Assertion Error analyzing " + this.flow.classFlow.name + "." + this.flow.name);
            System.err.println("Basic block " + this);
            System.err.println("i = " + i);
            System.err.println("Frame: " + frame);
            throw ae;
        }
    }

    public boolean isCatchHandler() {
        return this.caughtExceptionType != null;
    }

    void mergeSuccessors(Frame frame) {
        for (BasicBlock s : this.successors) {
            s.merge(frame, false);
        }
    }

    void merge(Frame inframe, boolean localsOnly) {
        boolean enqueue = true;
        if (this.startFrame == null) {
            this.startFrame = inframe.dup();
        } else {
            Frame ret = this.startFrame.merge(this.flow.detector, inframe, localsOnly, this.usage);
            if (ret == this.startFrame) {
                enqueue = false;
            } else {
                this.startFrame = ret;
            }
        }
        if (enqueue) {
            this.flow.enqueue(this);
        }
    }

    public void chooseCatchHandlers(ArrayList<Handler> handlerList) {
        for (Handler h : handlerList) {
            if (this == h.catchBB) {
                this.caughtExceptionType = TypeDesc.getInterned(h.type == null ? "java/lang/Throwable" : h.type);
                continue;
            }
            Range ri = Range.intersect(this.startPos, this.endPos, h.from, h.to);
            if (ri == null) continue;
            this.handlers.add(new Handler(ri.from, ri.to, h.type, h.catchBB));
        }
    }

    public AbstractInsnNode getInstruction(int pos) {
        return this.flow.instructions.get(pos);
    }

    String printGeniology() {
        String ts = "";
        for (BasicBlock succ : this.successors) {
            ts = ts + String.format(" %4d", succ.id);
        }
        String th = "";
        for (Handler h : this.handlers) {
            th = th + String.format(" %4d", h.catchBB.id);
        }
        return String.format("%4d:%-20s...%-20s", this.id, ts, th);
    }

    public boolean flowVarUsage() {
        if (this.succUsage == null) {
            this.succUsage = new ArrayList(this.successors.size() + this.handlers.size());
            for (BasicBlock succ : this.successors) {
                this.succUsage.add(succ.usage);
            }
            for (Handler h : this.handlers) {
                this.succUsage.add(h.catchBB.usage);
            }
        }
        return this.usage.evalLiveIn(this.succUsage, this.handlers);
    }

    ArrayList<BasicBlock> inline() throws KilimException {
        HashMap<BasicBlock, BasicBlock> bbCopyMap = null;
        HashMap<LabelNode, LabelNode> labelCopyMap = null;
        BasicBlock targetBB = this.successors.get(0);
        LabelNode returnToLabel = this.flow.getOrCreateLabelAtPos(this.endPos + 1);
        BasicBlock returnToBB = this.flow.getOrCreateBasicBlock(returnToLabel);
        boolean isPausableSub = targetBB.hasFlag(256);
        if (!targetBB.hasFlag(2)) {
            targetBB.setFlag(2);
            for (BasicBlock b : targetBB.getSubBlocks()) {
                if (b.lastInstruction() != 169) continue;
                assert (b.successors.size() == 0) : this.toString();
                b.addSuccessor(returnToBB);
            }
            return null;
        }
        bbCopyMap = new HashMap<BasicBlock, BasicBlock>(10);
        labelCopyMap = new HashMap<LabelNode, LabelNode>(10);
        this.successors.clear();
        targetBB.dupBBAndLabels(isPausableSub, bbCopyMap, labelCopyMap, returnToBB);
        this.addSuccessor(bbCopyMap.get(targetBB));
        return BasicBlock.dupCopyContents(isPausableSub, targetBB, returnToBB, bbCopyMap, labelCopyMap);
    }

    void dupBBAndLabels(boolean deepCopy, HashMap<BasicBlock, BasicBlock> bbCopyMap, HashMap<LabelNode, LabelNode> labelCopyMap, BasicBlock returnToBB) throws KilimException {
        for (BasicBlock orig : this.getSubBlocks()) {
            BasicBlock dup = new BasicBlock(this.flow, orig.startLabel);
            bbCopyMap.put(orig, dup);
            if (!deepCopy) continue;
            for (int i = orig.startPos; i <= orig.endPos; ++i) {
                LabelNode origLabel = this.flow.getLabelAt(i);
                if (origLabel == null) continue;
                LabelNode l = labelCopyMap.put(origLabel, new LabelNode());
                assert (l == null);
            }
        }
    }

    static ArrayList<BasicBlock> dupCopyContents(boolean deepCopy, BasicBlock targetBB, BasicBlock returnToBB, HashMap<BasicBlock, BasicBlock> bbCopyMap, HashMap<LabelNode, LabelNode> labelCopyMap) throws KilimException {
        ArrayList<BasicBlock> newBBs = new ArrayList<BasicBlock>(targetBB.getSubBlocks().size());
        for (BasicBlock orig : targetBB.getSubBlocks()) {
            BasicBlock dup = bbCopyMap.get(orig);
            dup.flags = orig.flags;
            dup.caughtExceptionType = orig.caughtExceptionType;
            dup.startPos = orig.startPos;
            dup.endPos = orig.endPos;
            dup.flow = orig.flow;
            dup.numPredecessors = orig.numPredecessors;
            dup.startFrame = null;
            dup.usage = orig.usage.copy();
            dup.handlers = orig.handlers;
            if (orig.follower != null) {
                dup.follower = bbCopyMap.get(orig.follower);
                if (dup.follower == null) assert (dup.lastInstruction() == 169);
            }
            dup.successors = new ArrayList(orig.successors.size());
            if (orig.lastInstruction() == 169) {
                dup.addSuccessor(returnToBB);
            } else {
                for (BasicBlock s : orig.successors) {
                    BasicBlock b = bbCopyMap.get(s);
                    dup.addSuccessor(b);
                }
            }
            if (deepCopy) {
                InsnList extraInsns = new InsnList();
                MethodFlow flow = targetBB.flow;
                InsnList instructions = flow.instructions;
                dup.startLabel = labelCopyMap.get(orig.startLabel);
                dup.startPos = instructions.size();
                dup.endPos = dup.startPos + (orig.endPos - orig.startPos);
                int newPos = instructions.size();
                int end = orig.endPos;
                int i = orig.startPos;
                while (i <= end) {
                    LabelNode l = flow.getLabelAt(i);
                    if (l != null) {
                        l = labelCopyMap.get(l);
                        assert (l != null);
                        flow.setLabel(newPos, l);
                    }
                    extraInsns.add(instructions.get(i).clone(labelCopyMap));
                    ++i;
                    ++newPos;
                }
                dup.handlers = new ArrayList(orig.handlers.size());
                if (orig.handlers.size() > 0) {
                    for (Handler oh : orig.handlers) {
                        Handler h = new Handler(dup.startPos + (oh.from - orig.startPos), dup.endPos + (oh.to - orig.endPos), oh.type, oh.catchBB);
                        dup.handlers.add(h);
                    }
                }
                instructions.add(extraInsns);
            }
            newBBs.add(dup);
        }
        return newBBs;
    }

    public BasicBlock getJSRTarget() {
        return this.lastInstruction() == 168 ? this.successors.get(0) : null;
    }

    public ArrayList<BasicBlock> getSubBlocks() throws KilimException {
        if (this.subBlocks == null) {
            if (!this.hasFlag(32)) {
                return null;
            }
            this.subBlocks = new ArrayList(10);
            Stack<BasicBlock> stack = new Stack<BasicBlock>();
            this.setFlag(64);
            stack.add(this);
            while (!stack.isEmpty()) {
                BasicBlock b = (BasicBlock)stack.pop();
                this.subBlocks.add(b);
                if (b.lastInstruction() == 168) {
                    BasicBlock follower = b.getFollowingBlock();
                    if (follower.hasFlag(64)) continue;
                    follower.setFlag(64);
                    stack.push(follower);
                    continue;
                }
                for (BasicBlock succ : b.successors) {
                    if (succ == this) {
                        throw new KilimException("JSRs looping back to themselves are not supported");
                    }
                    if (succ.hasFlag(64)) continue;
                    succ.setFlag(64);
                    stack.push(succ);
                }
            }
            Collections.sort(this.subBlocks);
        }
        return this.subBlocks;
    }

    BasicBlock getFollowingBlock() {
        if (this.follower != null) {
            return this.follower;
        }
        LabelNode l = this.flow.getLabelAt(this.endPos + 1);
        assert (l != null) : "No block follows this block: " + this;
        return this.flow.getBasicBlock(l);
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer(200);
        sb.append("\n========== BB #").append(this.id).append("[").append(System.identityHashCode(this)).append("]\n");
        sb.append("method: ").append(this.flow.name).append(this.flow.desc).append("\n");
        sb.append("start = ").append(this.startPos).append(",end = ").append(this.endPos).append('\n').append("Successors:");
        if (this.successors.isEmpty()) {
            sb.append(" None");
        } else {
            for (i = 0; i < this.successors.size(); ++i) {
                BasicBlock succ = this.successors.get(i);
                sb.append(" ").append(succ.id).append("[").append(System.identityHashCode(succ)).append("]");
            }
        }
        sb.append("\nHandlers:");
        if (this.handlers.isEmpty()) {
            sb.append(" None");
        } else {
            for (i = 0; i < this.handlers.size(); ++i) {
                sb.append(" ").append(this.handlers.get((int)i).catchBB.id);
            }
        }
        sb.append("\nStart frame:\n").append(this.startFrame);
        sb.append("\nUsage: ").append(this.usage);
        return sb.toString();
    }

    public boolean isPausable() {
        return this.hasFlag(16);
    }

    void setId(int aid) {
        this.id = aid;
    }

    void checkPausableJSR() throws KilimException {
        BasicBlock sub = this.getJSRTarget();
        boolean isPausableJSR = false;
        if (sub != null) {
            ArrayList<BasicBlock> subBlocks = sub.getSubBlocks();
            for (BasicBlock b : subBlocks) {
                if (!b.hasFlag(16)) continue;
                isPausableJSR = true;
                break;
            }
            if (isPausableJSR) {
                for (BasicBlock b : subBlocks) {
                    b.setFlag(256);
                }
            }
        }
    }

    void changeJSR_RET_toGOTOs() throws KilimException {
        int lastInsn = this.getInstruction(this.endPos).getOpcode();
        if (lastInsn == 168) {
            BasicBlock targetBB = this.successors.get(0);
            if (!targetBB.hasFlag(256)) {
                return;
            }
            this.changeLastInsnToGOTO(targetBB.startLabel);
            this.successors.clear();
            this.successors.add(targetBB);
            assert (targetBB.getInstruction(targetBB.startPos).getOpcode() == 58);
            targetBB.setInstruction(targetBB.startPos, new NopInsn());
            targetBB.unsetFlag(32);
        } else if (lastInsn == 169 && this.hasFlag(256)) {
            this.changeLastInsnToGOTO(this.successors.get((int)0).startLabel);
        }
    }

    void setInstruction(int pos, AbstractInsnNode insn) {
        this.flow.instructions.set(this.getInstruction(pos), insn);
    }

    void changeLastInsnToGOTO(LabelNode label) {
        this.setInstruction(this.endPos, (AbstractInsnNode)new JumpInsnNode(167, label));
    }

    public boolean isGetCurrentTask() {
        AbstractInsnNode ain = this.getInstruction(this.startPos);
        if (ain.getOpcode() == 184) {
            MethodInsnNode min = (MethodInsnNode)ain;
            return min.owner.equals("kilim/Task") && min.name.equals("getCurrentTask");
        }
        return false;
    }

    boolean isInitialized() {
        return this.startPos >= 0 && this.endPos >= 0;
    }
}

