/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import kilim.analysis.KilimContext;
import kilim.mirrors.Detector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class AsmDetector {
    static HashMap<String, ClassCache> classCacheMap = new HashMap();

    public static int getPausableStatus(String className, String methodName, String desc, Detector detector) {
        try {
            int status;
            ClassCache classCache = classCacheMap.get(className);
            if (classCache == null) {
                ClassReader cr = new ClassReader(className);
                ClassNode cn = new ClassNode();
                cr.accept((ClassVisitor)cn, 0);
                classCache = AsmDetector.cache(className, cn);
            }
            if ((status = classCache.getPausableStatus(methodName, desc)) == 0) {
                String superName;
                Iterator iterator = classCache.superClasses.iterator();
                while (iterator.hasNext() && (status = detector.getPausableStatus(superName = (String)iterator.next(), methodName, desc)) == 0) {
                }
            }
            return status;
        }
        catch (IOException ioe) {
            System.err.println("***Error reading " + className + ": " + ioe.getMessage());
            return 0;
        }
    }

    private static ClassCache cache(String className, ClassNode cn) {
        ClassCache classCache = new ClassCache();
        classCache.className = className;
        classCacheMap.put(className, classCache);
        block0: for (Object m : cn.methods) {
            MethodNode mn = (MethodNode)m;
            for (Object exception : mn.exceptions) {
                if (!"kilim/Pausable".equals(exception)) continue;
                classCache.pausableMethods.add(mn.name + mn.desc);
                continue block0;
            }
            classCache.otherMethods.add(mn.name + mn.desc);
        }
        classCache.addSuper(cn.superName);
        for (Object interfaceName : cn.interfaces) {
            classCache.addSuper((String)interfaceName);
        }
        return classCache;
    }

    public static void main(String[] args) {
        AsmDetector.getPausableStatus("com/sleepycat/je/Database", "putInternal", "Lcom/sleepycat/je/Transaction;Lcom/sleepycat/je/DatabaseEntry;Lcom/sleepycat/je/DatabaseEntry;Lcom/sleepycat/je/dbi/PutMode;Lkilim/Fiber;)Lcom/sleepycat/je/OperationStatus;)V", KilimContext.DEFAULT.detector);
    }

    static class ClassCache {
        String className;
        LinkedList<String> pausableMethods = new LinkedList();
        LinkedList<String> otherMethods = new LinkedList();
        LinkedList<String> superClasses = new LinkedList();

        ClassCache() {
        }

        public void addSuper(String superName) {
            if (superName.equals("java/lang/Object")) {
                return;
            }
            if (!this.superClasses.contains(superName)) {
                this.superClasses.add(superName);
            }
        }

        public int getPausableStatus(String methodName, String desc) {
            String md = methodName + desc;
            if (this.pausableMethods.contains(md)) {
                return 1;
            }
            if (this.otherMethods.contains(md)) {
                return 2;
            }
            return 0;
        }

        public String toString() {
            return this.className + "\nPausable Methods: " + this.pausableMethods + "\nOthers:" + this.otherMethods;
        }
    }
}

