/*
 * Decompiled with CFR 0.152.
 */
package kilim;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import kilim.KilimClassLoader;
import kilim.analysis.ClassInfo;
import kilim.analysis.ClassWeaver;
import kilim.analysis.FileLister;
import kilim.analysis.KilimContext;
import kilim.mirrors.CachedClassMirrors;
import kilim.tools.Agent;
import kilim.tools.Weaver;

public class WeavingClassLoader
extends KilimClassLoader {
    public static final String KILIM_CLASSPATH = "kilim.class.path";
    Weaver weaver;
    URLClassLoader proxy;
    ClassLoader pcl;
    static ClassLoader platform;
    private final HashMap<URL, ProtectionDomain> cache = new HashMap();

    public static byte[] readFully(InputStream is) {
        try {
            int num;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[4096];
            while ((num = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, num);
            }
            buffer.flush();
            return buffer.toByteArray();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static URL[] getURLs(String[] classPaths) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String name : classPaths) {
            if ((name = name.trim()).equals("")) continue;
            try {
                urls.add(new File(name).toURI().toURL());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        URL[] paths = urls.toArray(new URL[0]);
        return paths;
    }

    public WeavingClassLoader() {
        this(null, WeavingClassLoader.getProxy());
    }

    private static URLClassLoader getProxy() {
        String classPath = System.getProperty(KILIM_CLASSPATH, "");
        String[] classPaths = classPath.split(":");
        URL[] paths = WeavingClassLoader.getURLs(classPaths);
        return paths.length > 0 ? new URLClassLoader(paths) : null;
    }

    public WeavingClassLoader(ClassLoader loader, URLClassLoader $proxy) {
        this.proxy = $proxy;
        this.pcl = this.proxy != null ? this.proxy : (loader != null ? loader : this.getClass().getClassLoader());
        CachedClassMirrors ccm = new CachedClassMirrors(this.pcl);
        KilimContext kc = new KilimContext(ccm);
        this.weaver = new Weaver(kc);
    }

    public void run(String className, String method, String ... args) throws Exception {
        Class<?> mainClass = this.loadClass(className);
        Method mainMethod = mainClass.getMethod(method, String[].class);
        mainMethod.invoke(null, new Object[]{args});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> klass = null;
        try {
            klass = platform.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (klass == null) {
            klass = this.findLoadedClass(name);
        }
        if (klass == null) {
            WeavingClassLoader weavingClassLoader = this;
            synchronized (weavingClassLoader) {
                klass = this.findLoadedClass(name);
                if (klass == null) {
                    klass = this.findClass(name);
                }
            }
        }
        if (resolve) {
            this.resolveClass(klass);
        }
        return klass;
    }

    private boolean proxy(String cname) {
        return this.proxy != null && this.proxy.findResource(cname) == null;
    }

    private Class defineAll(String name, ClassWeaver cw) {
        Class<?> ret = null;
        for (ClassInfo ci : cw.getClassInfos()) {
            if (this.findLoadedClass(ci.className) != null) continue;
            Class<?> c = this.define(ci.className, ci.bytes);
            if (ci.className.equals(name)) {
                ret = c;
                continue;
            }
            if (!ci.className.startsWith("kilim.S")) continue;
            this.resolveClass(c);
        }
        return ret;
    }

    public static InputStream getByteStream(ClassLoader cl, String name, String cname) {
        InputStream is = cl.getResourceAsStream(cname);
        if (is == null) {
            is = ClassLoader.getSystemResourceAsStream(cname);
        }
        if (is == null & Agent.map != null) {
            try {
                cl.loadClass(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            byte[] bytes = Agent.map.get(cname);
            if (bytes != null) {
                is = new ByteArrayInputStream(bytes);
            }
        }
        return is;
    }

    public ClassWeaver weaveClass(String name) {
        String cname = WeavingClassLoader.makeResourceName(name);
        InputStream is = WeavingClassLoader.getByteStream(this.pcl, name, cname);
        ClassWeaver cw = this.weaver.weave(is);
        return cw;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String cname = WeavingClassLoader.makeResourceName(name);
        InputStream is = WeavingClassLoader.getByteStream(this.pcl, name, cname);
        if (is != null) {
            if (this.proxy(cname)) {
                byte[] code = WeavingClassLoader.readFully(is);
                if (code != null) {
                    return this.define(name, code);
                }
            } else {
                ClassWeaver cw = this.weaver.weave(is);
                if (cw != null) {
                    Class<?> ret = this.defineAll(name, cw);
                    return ret == null ? this.define(name, cw.classFlow.code) : ret;
                }
            }
        }
        throw new ClassNotFoundException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtectionDomain get(String name) {
        URL url = this.url(name);
        if (url == null) {
            return null;
        }
        ProtectionDomain pd = null;
        HashMap<URL, ProtectionDomain> hashMap = this.cache;
        synchronized (hashMap) {
            pd = this.cache.get(url);
            if (pd == null) {
                CodeSource cs = new CodeSource(url, (CodeSigner[])null);
                pd = new ProtectionDomain(cs, null, this, null);
                this.cache.put(url, pd);
            }
        }
        return pd;
    }

    public Class<?> define(String name, byte[] code) {
        Object cm = null;
        return this.defineClass(name, code, 0, code.length, this.get(name));
    }

    public static String makeResourceName(String name) {
        return name.replace('.', '/') + ".class";
    }

    public static byte[] findCode(ClassLoader loader, String name) {
        String cname;
        InputStream is;
        if (loader == null) {
            loader = WeavingClassLoader.class.getClassLoader();
        }
        if ((is = WeavingClassLoader.getByteStream(loader, name, cname = WeavingClassLoader.makeResourceName(name))) != null) {
            return WeavingClassLoader.readFully(is);
        }
        return null;
    }

    public URL url(String name) {
        String cname = WeavingClassLoader.makeResourceName(name);
        URL url = this.pcl.getResource(cname);
        URL ret = null;
        if (url == null) {
            url = ClassLoader.getSystemResource(cname);
        }
        if (url == null) {
            return null;
        }
        String path = url.getPath();
        boolean matches = path.endsWith(cname);
        assert (matches) : "url code source doesn't match expectation: " + name + ", " + path;
        if (!matches) {
            return null;
        }
        try {
            ret = new URL(url, path.replace(cname, ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static byte[] readFully(FileLister.Entry fe) throws IOException {
        DataInputStream in = new DataInputStream(fe.getInputStream());
        byte[] contents = new byte[(int)fe.getSize()];
        in.readFully(contents);
        in.close();
        return contents;
    }

    static {
        ClassLoader cl;
        ClassLoader last = cl = WeavingClassLoader.class.getClassLoader();
        while (cl != null) {
            last = cl;
            cl = cl.getParent();
        }
        platform = last;
    }
}

