/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.unix.maven.deb;

import fj.F2;
import fj.data.List;
import fj.data.Option;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.codehaus.mojo.unix.FileAttributes;
import org.codehaus.mojo.unix.FileCollector;
import org.codehaus.mojo.unix.PackageParameters;
import org.codehaus.mojo.unix.PackageVersion;
import org.codehaus.mojo.unix.UnixFsObject;
import org.codehaus.mojo.unix.UnixPackage;
import org.codehaus.mojo.unix.core.FsFileCollector;
import org.codehaus.mojo.unix.deb.ControlFile;
import org.codehaus.mojo.unix.deb.Dpkg;
import org.codehaus.mojo.unix.util.ScriptUtil;
import org.codehaus.mojo.unix.util.UnixUtil;
import org.codehaus.mojo.unix.util.line.LineStreamUtil;
import org.codehaus.mojo.unix.util.vfs.VfsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebUnixPackage
extends UnixPackage {
    private static final String EOL = System.getProperty("line.separator");
    private ControlFile controlFile;
    private FileObject workingDirectory;
    private FsFileCollector fileCollector;
    private boolean useFakeroot;
    private boolean debug;
    private static final ScriptUtil scriptUtil = new ScriptUtil("preinst", "postinst", "prerm", "postrm");

    public DebUnixPackage() {
        super("deb");
    }

    public DebUnixPackage parameters(PackageParameters parameters) {
        this.controlFile = new ControlFile(parameters.id).version(Option.some((Object)DebUnixPackage.getDebianVersion(parameters.version))).description(DebUnixPackage.getDescription(parameters)).maintainer(parameters.contact).architecture(parameters.architecture.orElse(Option.some((Object)"all")));
        return this;
    }

    public DebUnixPackage debParameters(Option<String> priority, Option<String> section, boolean useFakeroot, List<String> depends, List<String> recommends, List<String> suggests, List<String> preDepends, List<String> provides, List<String> replaces) {
        this.useFakeroot = useFakeroot;
        this.controlFile = this.controlFile.priority(priority).section(section).depends(depends).recommends(recommends).suggests(suggests).preDepends(preDepends).provides(provides).replaces(replaces);
        return this;
    }

    public DebUnixPackage workingDirectory(FileObject workingDirectory) throws FileSystemException {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public DebUnixPackage debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public void beforeAssembly(FileAttributes defaultDirectoryAttributes) throws IOException {
        this.fileCollector = new FsFileCollector(this.workingDirectory.resolveFile("assembly"));
    }

    public FileObject getRoot() {
        return this.fileCollector.getRoot();
    }

    public FileCollector addDirectory(UnixFsObject.Directory directory) {
        this.fileCollector.addDirectory(directory);
        return this;
    }

    public FileCollector addFile(FileObject fromFile, UnixFsObject.RegularFile file) {
        this.fileCollector.addFile(fromFile, file);
        return this;
    }

    public FileCollector addSymlink(UnixFsObject.Symlink symlink) throws IOException {
        this.fileCollector.addSymlink(symlink);
        return this;
    }

    public void apply(F2<UnixFsObject, FileAttributes, FileAttributes> f) {
        this.fileCollector.apply(f);
    }

    public void packageToFile(File packageFile, ScriptUtil.Strategy strategy) throws Exception {
        FileObject fsRoot = this.fileCollector.getFsRoot();
        FileObject debian = fsRoot.resolveFile("DEBIAN");
        FileObject controlFilePath = debian.resolveFile("control");
        debian.createFolder();
        LineStreamUtil.toFile((List)this.controlFile.toList(), (File)VfsUtil.asFile((FileObject)controlFilePath));
        this.fileCollector.collect();
        ScriptUtil.Result result = scriptUtil.createExecution(this.controlFile.packageName, "deb", this.getScripts(), VfsUtil.asFile((FileObject)debian), strategy).execute();
        UnixUtil.chmodIf((Option)result.preInstall, (String)"0755");
        UnixUtil.chmodIf((Option)result.postInstall, (String)"0755");
        UnixUtil.chmodIf((Option)result.preRemove, (String)"0755");
        UnixUtil.chmodIf((Option)result.postRemove, (String)"0755");
        new Dpkg().setDebug(this.debug).setPackageRoot(VfsUtil.asFile((FileObject)fsRoot)).setDebFile(packageFile).setUseFakeroot(this.useFakeroot).execute();
    }

    public static DebUnixPackage cast(UnixPackage unixPackage) {
        return (DebUnixPackage)unixPackage;
    }

    public static Option<String> getDescription(PackageParameters parameters) {
        String debianDescription;
        String description = parameters.name.trim();
        if (parameters.description.isSome()) {
            description = description + EOL + ((String)parameters.description.some()).trim();
        }
        try {
            BufferedReader reader = new BufferedReader(new StringReader(description.trim()));
            debianDescription = reader.readLine();
            String line = reader.readLine();
            if (line != null) {
                debianDescription = debianDescription + EOL + " " + line.trim();
                line = reader.readLine();
            }
            while (line != null) {
                debianDescription = (line = line.trim()).equals("") ? debianDescription + EOL + "." : debianDescription + EOL + " " + line;
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Internal error", e);
        }
        return Option.some((Object)debianDescription);
    }

    public static String getDebianVersion(PackageVersion version) {
        String v = version.version;
        if (version.revision.isSome()) {
            v = v + "-" + Integer.parseInt((String)version.revision.some());
        }
        if (!version.snapshot) {
            return v;
        }
        return v + "-" + version.timestamp;
    }
}

