/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.ArrayList;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.ConstructorReferenceSearchRequestor;
import org.eclipse.jdt.groovy.search.FieldReferenceSearchRequestor;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.LocalVariableReferenceRequestor;
import org.eclipse.jdt.groovy.search.MethodReferenceSearchRequestor;
import org.eclipse.jdt.groovy.search.OrPatternRequestor;
import org.eclipse.jdt.groovy.search.TypeDeclarationSearchRequestor;
import org.eclipse.jdt.groovy.search.TypeReferenceSearchRequestor;
import org.eclipse.jdt.internal.core.search.matching.ConstructorPattern;
import org.eclipse.jdt.internal.core.search.matching.FieldPattern;
import org.eclipse.jdt.internal.core.search.matching.LocalVariablePattern;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.search.matching.OrPattern;
import org.eclipse.jdt.internal.core.search.matching.PossibleMatch;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.jdt.internal.core.search.matching.TypeReferencePattern;
import org.eclipse.jdt.internal.core.util.Util;

public class TypeRequestorFactory {
    public ITypeRequestor createRequestor(PossibleMatch possibleMatch, SearchPattern pattern, SearchRequestor requestor) {
        if (pattern instanceof TypeReferencePattern) {
            return new TypeReferenceSearchRequestor((TypeReferencePattern)pattern, requestor, possibleMatch.document.getParticipant());
        }
        if (pattern instanceof TypeDeclarationPattern) {
            return new TypeDeclarationSearchRequestor((TypeDeclarationPattern)pattern, requestor, possibleMatch.document.getParticipant());
        }
        if (pattern instanceof FieldPattern) {
            return new FieldReferenceSearchRequestor((FieldPattern)pattern, requestor, possibleMatch.document.getParticipant());
        }
        if (pattern instanceof MethodPattern) {
            return new MethodReferenceSearchRequestor((MethodPattern)pattern, requestor, possibleMatch.document.getParticipant());
        }
        if (pattern instanceof LocalVariablePattern) {
            int start;
            ILocalVariable localVar = (ILocalVariable)ReflectionUtils.getPrivateField(LocalVariablePattern.class, "localVariable", pattern);
            try {
                start = localVar.getSourceRange().getOffset();
            }
            catch (JavaModelException e) {
                Util.log(e);
                start = -1;
            }
            return new LocalVariableReferenceRequestor(localVar.getElementName(), localVar.getParent(), requestor, possibleMatch.document.getParticipant(), start);
        }
        if (pattern instanceof ConstructorPattern) {
            return new ConstructorReferenceSearchRequestor((ConstructorPattern)pattern, requestor, possibleMatch.document.getParticipant());
        }
        if (pattern instanceof OrPattern) {
            SearchPattern[] patterns = this.getPatterns((OrPattern)pattern);
            ArrayList<ITypeRequestor> requestors = new ArrayList<ITypeRequestor>(patterns.length);
            SearchPattern[] searchPatternArray = patterns;
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeRequestor maybeRequestor;
                SearchPattern orPattern = searchPatternArray[n2];
                if (orPattern != null && (maybeRequestor = this.createRequestor(possibleMatch, orPattern, requestor)) != null) {
                    requestors.add(maybeRequestor);
                }
                ++n2;
            }
            return new OrPatternRequestor(requestors);
        }
        return null;
    }

    private SearchPattern[] getPatterns(OrPattern pattern) {
        return (SearchPattern[])ReflectionUtils.getPrivateField(OrPattern.class, "patterns", pattern);
    }
}

