/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy23;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateExportedPackages {
    public static final String GROOVY_ALL_PATH = "lib/groovy-all-2.4.3.jar";
    public static final String MANIFEST = "META-INF/MANIFEST.MF";

    public static void main(String[] args) throws Exception {
        JarFile jar = new JarFile(new File(GROOVY_ALL_PATH));
        try {
            TreeSet<String> packages = new TreeSet<String>();
            UpdateExportedPackages.readCurrentManifest(packages);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                int lastSlash;
                JarEntry el = entries.nextElement();
                String pathName = el.getName();
                if (!pathName.endsWith(".class") || (lastSlash = pathName.lastIndexOf(47)) < 0) continue;
                String pkg = pathName.substring(0, lastSlash).replace('/', '.');
                packages.add(pkg);
            }
            boolean first = true;
            for (String pkg : packages) {
                System.out.print(first ? "Export-Package: " : ",\n ");
                System.out.print(pkg);
                first = false;
            }
            System.out.println();
        }
        finally {
            jar.close();
        }
    }

    private static void readCurrentManifest(TreeSet<String> packages) throws Exception {
        Manifest manifest = new Manifest();
        FileInputStream is = new FileInputStream(new File(MANIFEST));
        try {
            String[] pkgs;
            manifest.read(is);
            String epa = manifest.getMainAttributes().getValue("Export-Package");
            String[] stringArray = pkgs = epa.split("\\,(\\s)*");
            int n = pkgs.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                packages.add(p);
                ++n2;
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }
}

