/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImmutableClassNode
extends ClassNode {
    private boolean genericsInitialized = false;
    private boolean writeProtected = false;

    public ImmutableClassNode(Class c) {
        super(c);
    }

    @Override
    public void setGenericsTypes(GenericsType[] genericsTypes) {
        if (this.genericsInitialized && genericsTypes != this.genericsTypes) {
            throw new GroovyBugError("Attempt to change an immutable Groovy class: " + this.getName());
        }
        if (genericsTypes != null) {
            GenericsType[] immutable = new GenericsType[genericsTypes.length];
            int i = 0;
            while (i < genericsTypes.length) {
                immutable[i] = new ImmutableGenericsType(genericsTypes[i]);
                ++i;
            }
            genericsTypes = immutable;
        }
        super.setGenericsTypes(genericsTypes);
        this.genericsInitialized = true;
    }

    @Override
    public List<MethodNode> getDeclaredMethods(String name) {
        if (this.lazyInitDone && !this.writeProtected) {
            this.enableWriteProtection();
        }
        return super.getDeclaredMethods(name);
    }

    private synchronized void enableWriteProtection() {
        for (Object key : this.methods.map.keySet()) {
            List<MethodNode> l = this.methods.get(key);
            this.methods.map.put(key, Collections.unmodifiableList(l));
        }
        this.methods.map = Collections.unmodifiableMap(this.methods.map);
        this.writeProtected = true;
    }

    class ImmutableGenericsType
    extends GenericsType {
        ImmutableGenericsType(GenericsType delegate) {
            super.setType(delegate.getType());
            super.setPlaceholder(delegate.isPlaceholder());
            super.setResolved(delegate.isResolved());
            super.setName(delegate.getName());
            super.setWildcard(delegate.isWildcard());
            super.setUpperBounds(delegate.getUpperBounds());
            super.setLowerBound(delegate.getLowerBound());
        }

        public void setType(ClassNode type) {
            throw new GroovyBugError("Attempt to change an immutable Groovy class: " + ImmutableClassNode.this.getName());
        }

        public void setPlaceholder(boolean placeholder) {
            throw new GroovyBugError("Attempt to change an immutable Groovy class: " + ImmutableClassNode.this.getName());
        }

        public void setResolved(boolean res) {
            throw new GroovyBugError("Attempt to change an immutable Groovy class: " + ImmutableClassNode.this.getName());
        }

        public void setName(String name) {
            throw new GroovyBugError("Attempt to change an immutable Groovy class: " + ImmutableClassNode.this.getName());
        }

        public void setWildcard(boolean wildcard) {
            throw new GroovyBugError("Attempt to change an immutable Groovy class: " + ImmutableClassNode.this.getName());
        }

        public void setUpperBounds(ClassNode[] bounds) {
            throw new GroovyBugError("Attempt to change an immutable Groovy class: " + ImmutableClassNode.this.getName());
        }

        public void setLowerBound(ClassNode bound) {
            throw new GroovyBugError("Attempt to change an immutable Groovy class: " + ImmutableClassNode.this.getName());
        }
    }
}

