/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.ast.tools;

import java.util.List;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class ConstructorNodeUtils {
    private ConstructorNodeUtils() {
    }

    public static ConstructorCallExpression getFirstIfSpecialConstructorCall(Statement code) {
        if (code == null) {
            return null;
        }
        if (code instanceof BlockStatement) {
            BlockStatement block = (BlockStatement)code;
            List<Statement> statementList = block.getStatements();
            if (statementList.isEmpty()) {
                return null;
            }
            return ConstructorNodeUtils.getFirstIfSpecialConstructorCall(statementList.get(0));
        }
        if (!(code instanceof ExpressionStatement)) {
            return null;
        }
        Expression expression = ((ExpressionStatement)code).getExpression();
        if (!(expression instanceof ConstructorCallExpression)) {
            return null;
        }
        ConstructorCallExpression cce = (ConstructorCallExpression)expression;
        if (cce.isSpecialCall()) {
            return cce;
        }
        return null;
    }
}

