/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.spring;

import org.apache.commons.lang3.StringUtils;
import org.bytesoft.transaction.aware.TransactionDebuggable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class TransactionDebuggablePostProcessor
implements BeanPostProcessor,
EnvironmentAware {
    static final String KEY_DEBUGGABLE = "org.bytesoft.bytejta.debuggable";
    private Environment environment;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.setDebuggableIfNecessary(bean);
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        this.setDebuggableIfNecessary(bean);
        return bean;
    }

    private void setDebuggableIfNecessary(Object bean) {
        if (TransactionDebuggable.class.isInstance(bean)) {
            String debuggable = this.environment.getProperty(KEY_DEBUGGABLE);
            TransactionDebuggable target = (TransactionDebuggable)bean;
            target.setDebuggingEnabled(StringUtils.equalsIgnoreCase((CharSequence)Boolean.TRUE.toString(), (CharSequence)debuggable));
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

