/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.coyote.ActionCode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;

public class FormAuthenticator
extends AuthenticatorBase {
    private final Log log = LogFactory.getLog(FormAuthenticator.class);
    protected static final String info = "org.apache.catalina.authenticator.FormAuthenticator/1.0";
    protected String characterEncoding = null;
    protected String landingPage = null;

    @Override
    public String getInfo() {
        return info;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String encoding) {
        this.characterEncoding = encoding;
    }

    public String getLandingPage() {
        return this.landingPage;
    }

    public void setLandingPage(String landingPage) {
        this.landingPage = landingPage;
    }

    @Override
    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        boolean loginAction;
        if (this.checkForCachedAuthentication(request, response, true)) {
            return true;
        }
        Session session = null;
        Principal principal = null;
        if (!this.cache) {
            session = request.getSessionInternal(true);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Checking for reauthenticate in session " + session));
            }
            String username = (String)session.getNote("org.apache.catalina.session.USERNAME");
            String password = (String)session.getNote("org.apache.catalina.session.PASSWORD");
            if (username != null && password != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Reauthenticating username '" + username + "'"));
                }
                if ((principal = this.context.getRealm().authenticate(username, password)) != null) {
                    session.setNote("org.apache.catalina.authenticator.PRINCIPAL", principal);
                    if (!this.matchRequest(request)) {
                        this.register(request, response, principal, "FORM", username, password);
                        return true;
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Reauthentication failed, proceed normally");
                }
            }
        }
        if (this.matchRequest(request)) {
            session = request.getSessionInternal(true);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Restore request from session '" + session.getIdInternal() + "'"));
            }
            principal = (Principal)session.getNote("org.apache.catalina.authenticator.PRINCIPAL");
            this.register(request, response, principal, "FORM", (String)session.getNote("org.apache.catalina.session.USERNAME"), (String)session.getNote("org.apache.catalina.session.PASSWORD"));
            if (this.cache) {
                session.removeNote("org.apache.catalina.session.USERNAME");
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
            if (this.restoreRequest(request, session)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Proceed to restored request");
                }
                return true;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Restore of original request failed");
            }
            response.sendError(400);
            return false;
        }
        MessageBytes uriMB = MessageBytes.newInstance();
        CharChunk uriCC = uriMB.getCharChunk();
        uriCC.setLimit(-1);
        String contextPath = request.getContextPath();
        String requestURI = request.getDecodedRequestURI();
        boolean bl = loginAction = requestURI.startsWith(contextPath) && requestURI.endsWith("/j_security_check");
        if (!loginAction) {
            if (request.getServletPath().length() == 0 && request.getPathInfo() == null) {
                StringBuilder location = new StringBuilder(requestURI);
                location.append('/');
                if (request.getQueryString() != null) {
                    location.append('?');
                    location.append(request.getQueryString());
                }
                response.sendRedirect(response.encodeRedirectURL(location.toString()));
                return false;
            }
            session = request.getSessionInternal(true);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Save request in session '" + session.getIdInternal() + "'"));
            }
            try {
                this.saveRequest(request, session);
            }
            catch (IOException ioe) {
                this.log.debug((Object)"Request body too big to save during authentication");
                response.sendError(403, sm.getString("authenticator.requestBodyTooBig"));
                return false;
            }
            this.forwardToLoginPage(request, response, config);
            return false;
        }
        request.getResponse().sendAcknowledgement();
        Realm realm = this.context.getRealm();
        if (this.characterEncoding != null) {
            request.setCharacterEncoding(this.characterEncoding);
        }
        String username = request.getParameter("j_username");
        String password = request.getParameter("j_password");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Authenticating username '" + username + "'"));
        }
        if ((principal = realm.authenticate(username, password)) == null) {
            this.forwardToErrorPage(request, response, config);
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Authentication of '" + username + "' was successful"));
        }
        if (session == null) {
            session = request.getSessionInternal(false);
        }
        if (session == null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"User took so long to log on the session expired");
            }
            if (this.landingPage == null) {
                response.sendError(408, sm.getString("authenticator.sessionExpired"));
            } else {
                String uri = request.getContextPath() + this.landingPage;
                SavedRequest saved = new SavedRequest();
                saved.setMethod("GET");
                saved.setRequestURI(uri);
                saved.setDecodedRequestURI(uri);
                request.getSessionInternal(true).setNote("org.apache.catalina.authenticator.REQUEST", saved);
                response.sendRedirect(response.encodeRedirectURL(uri));
            }
            return false;
        }
        session.setNote("org.apache.catalina.authenticator.PRINCIPAL", principal);
        session.setNote("org.apache.catalina.session.USERNAME", username);
        session.setNote("org.apache.catalina.session.PASSWORD", password);
        requestURI = this.savedRequestURL(session);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Redirecting to original '" + requestURI + "'"));
        }
        if (requestURI == null) {
            if (this.landingPage == null) {
                response.sendError(400, sm.getString("authenticator.formlogin"));
            } else {
                String uri = request.getContextPath() + this.landingPage;
                SavedRequest saved = new SavedRequest();
                saved.setMethod("GET");
                saved.setRequestURI(uri);
                saved.setDecodedRequestURI(uri);
                session.setNote("org.apache.catalina.authenticator.REQUEST", saved);
                response.sendRedirect(response.encodeRedirectURL(uri));
            }
        } else {
            response.sendRedirect(response.encodeRedirectURL(requestURI));
        }
        return false;
    }

    @Override
    protected String getAuthMethod() {
        return "FORM";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forwardToLoginPage(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        Session session;
        String loginPage;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("formAuthenticator.forwardLogin", request.getRequestURI(), request.getMethod(), config.getLoginPage(), this.context.getName()));
        }
        if ((loginPage = config.getLoginPage()) == null || loginPage.length() == 0) {
            String msg = sm.getString("formAuthenticator.noLoginPage", this.context.getName());
            this.log.warn((Object)msg);
            response.sendError(500, msg);
            return;
        }
        if (this.getChangeSessionIdOnAuthentication() && (session = request.getSessionInternal(false)) != null) {
            Manager manager = request.getContext().getManager();
            manager.changeSessionId(session);
            request.changeSessionId(session.getId());
        }
        String oldMethod = request.getMethod();
        request.getCoyoteRequest().method().setString("GET");
        RequestDispatcher disp = this.context.getServletContext().getRequestDispatcher(loginPage);
        try {
            if (this.context.fireRequestInitEvent(request.getRequest())) {
                disp.forward(request.getRequest(), response);
                this.context.fireRequestDestroyEvent(request.getRequest());
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            String msg = sm.getString("formAuthenticator.forwardLoginFail");
            this.log.warn((Object)msg, t);
            request.setAttribute("javax.servlet.error.exception", t);
            response.sendError(500, msg);
        }
        finally {
            request.getCoyoteRequest().method().setString(oldMethod);
        }
    }

    protected void forwardToErrorPage(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        String errorPage = config.getErrorPage();
        if (errorPage == null || errorPage.length() == 0) {
            String msg = sm.getString("formAuthenticator.noErrorPage", this.context.getName());
            this.log.warn((Object)msg);
            response.sendError(500, msg);
            return;
        }
        RequestDispatcher disp = this.context.getServletContext().getRequestDispatcher(config.getErrorPage());
        try {
            if (this.context.fireRequestInitEvent(request.getRequest())) {
                disp.forward(request.getRequest(), response);
                this.context.fireRequestDestroyEvent(request.getRequest());
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            String msg = sm.getString("formAuthenticator.forwardErrorFail");
            this.log.warn((Object)msg, t);
            request.setAttribute("javax.servlet.error.exception", t);
            response.sendError(500, msg);
        }
    }

    protected boolean matchRequest(Request request) {
        Session session = request.getSessionInternal(false);
        if (session == null) {
            return false;
        }
        SavedRequest sreq = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (sreq == null) {
            return false;
        }
        if (session.getNote("org.apache.catalina.authenticator.PRINCIPAL") == null) {
            return false;
        }
        String decodedRequestURI = request.getDecodedRequestURI();
        if (decodedRequestURI == null) {
            return false;
        }
        return decodedRequestURI.equals(sreq.getDecodedRequestURI());
    }

    protected boolean restoreRequest(Request request, Session session) throws IOException {
        SavedRequest saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        session.removeNote("org.apache.catalina.authenticator.REQUEST");
        session.removeNote("org.apache.catalina.authenticator.PRINCIPAL");
        if (saved == null) {
            return false;
        }
        byte[] buffer = new byte[4096];
        ServletInputStream is = request.createInputStream();
        while (is.read(buffer) >= 0) {
        }
        request.clearCookies();
        Iterator<Cookie> cookies = saved.getCookies();
        while (cookies.hasNext()) {
            request.addCookie(cookies.next());
        }
        String method = saved.getMethod();
        MimeHeaders rmh = request.getCoyoteRequest().getMimeHeaders();
        rmh.recycle();
        boolean cacheable = "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
        Iterator<String> names = saved.getHeaderNames();
        while (names.hasNext()) {
            String name = names.next();
            if ("If-Modified-Since".equalsIgnoreCase(name) || cacheable && "If-None-Match".equalsIgnoreCase(name)) continue;
            Iterator<String> values = saved.getHeaderValues(name);
            while (values.hasNext()) {
                rmh.addValue(name).setString(values.next());
            }
        }
        request.clearLocales();
        Iterator<Locale> locales = saved.getLocales();
        while (locales.hasNext()) {
            request.addLocale(locales.next());
        }
        request.getCoyoteRequest().getParameters().recycle();
        request.getCoyoteRequest().getParameters().setQueryStringEncoding(request.getConnector().getURIEncoding());
        ByteChunk body = saved.getBody();
        if (body != null) {
            request.getCoyoteRequest().action(ActionCode.REQ_SET_BODY_REPLAY, body);
            MessageBytes contentType = MessageBytes.newInstance();
            String savedContentType = saved.getContentType();
            if (savedContentType == null && "POST".equalsIgnoreCase(method)) {
                savedContentType = "application/x-www-form-urlencoded";
            }
            contentType.setString(savedContentType);
            request.getCoyoteRequest().setContentType(contentType);
        }
        request.getCoyoteRequest().method().setString(method);
        request.getRequestURI();
        request.getQueryString();
        request.getProtocol();
        request.getCoyoteRequest().queryString().setString(saved.getQueryString());
        request.getCoyoteRequest().requestURI().setString(saved.getRequestURI());
        return true;
    }

    protected void saveRequest(Request request, Session session) throws IOException {
        SavedRequest saved = new SavedRequest();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                saved.addCookie(cookies[i]);
            }
        }
        Enumeration<String> names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            Enumeration<String> values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = values.nextElement();
                saved.addHeader(name, value);
            }
        }
        Enumeration<Locale> locales = request.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = locales.nextElement();
            saved.addLocale(locale);
        }
        request.getResponse().sendAcknowledgement();
        int maxSavePostSize = request.getConnector().getMaxSavePostSize();
        if (maxSavePostSize != 0) {
            int bytesRead;
            ByteChunk body = new ByteChunk();
            body.setLimit(maxSavePostSize);
            byte[] buffer = new byte[4096];
            ServletInputStream is = request.getInputStream();
            while ((bytesRead = is.read(buffer)) >= 0) {
                body.append(buffer, 0, bytesRead);
            }
            if (body.getLength() > 0) {
                saved.setContentType(request.getContentType());
                saved.setBody(body);
            }
        }
        saved.setMethod(request.getMethod());
        saved.setQueryString(request.getQueryString());
        saved.setRequestURI(request.getRequestURI());
        saved.setDecodedRequestURI(request.getDecodedRequestURI());
        session.setNote("org.apache.catalina.authenticator.REQUEST", saved);
    }

    protected String savedRequestURL(Session session) {
        SavedRequest saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (saved == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(saved.getRequestURI());
        if (saved.getQueryString() != null) {
            sb.append('?');
            sb.append(saved.getQueryString());
        }
        return sb.toString();
    }
}

