/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition.dao;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tiles.BasicAttributeContext;
import org.apache.tiles.Definition;
import org.apache.tiles.definition.NoSuchDefinitionException;
import org.apache.tiles.definition.dao.CachingLocaleUrlDefinitionDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvingLocaleUrlDefinitionDAO
extends CachingLocaleUrlDefinitionDAO {
    private final Logger log = LoggerFactory.getLogger(ResolvingLocaleUrlDefinitionDAO.class);

    @Override
    protected Map<String, Definition> loadParentDefinitions(Locale parentLocale) {
        return this.loadDefinitionsFromURLs(parentLocale);
    }

    @Override
    protected Map<String, Definition> loadDefinitionsFromURLs(Locale customizationKey) {
        Map<String, Definition> retValue = super.loadDefinitionsFromURLs(customizationKey);
        Map defsMap = (Map)this.locale2definitionMap.get(customizationKey);
        this.resolveInheritances(defsMap, customizationKey);
        return retValue;
    }

    @Override
    protected Definition getDefinitionFromResolver(String name, Locale customizationKey) {
        Definition retValue = super.getDefinitionFromResolver(name, customizationKey);
        if (retValue != null && retValue.getExtends() != null) {
            Definition parent = this.getDefinition(retValue.getExtends(), customizationKey);
            retValue.inherit((BasicAttributeContext)parent);
        }
        return retValue;
    }

    @Override
    @Deprecated
    protected void postDefinitionLoadOperations(Map<String, Definition> localeDefsMap, Locale customizationKey) {
        this.resolveInheritances(localeDefsMap, customizationKey);
        super.postDefinitionLoadOperations(localeDefsMap, customizationKey);
    }

    protected void resolveInheritances(Map<String, Definition> map, Locale locale) {
        if (map != null) {
            HashSet<String> alreadyResolvedDefinitions = new HashSet<String>();
            for (Definition definition : map.values()) {
                this.resolveInheritance(definition, map, locale, alreadyResolvedDefinitions);
            }
        }
    }

    protected void resolveInheritance(Definition definition, Map<String, Definition> definitions, Locale locale, Set<String> alreadyResolvedDefinitions) {
        if (!definition.isExtending() || alreadyResolvedDefinitions.contains(definition.getName())) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Resolve definition for child name='" + definition.getName() + "' extends='" + definition.getExtends() + "'.");
        }
        alreadyResolvedDefinitions.add(definition.getName());
        Definition parent = definitions.get(definition.getExtends());
        if (parent == null) {
            String msg = "Error while resolving definition inheritance: child '" + definition.getName() + "' can't find its ancestor '" + definition.getExtends() + "'. Please check your description file.";
            throw new NoSuchDefinitionException(msg);
        }
        this.resolveInheritance(parent, definitions, locale, alreadyResolvedDefinitions);
        definition.inherit((BasicAttributeContext)parent);
    }

    @Override
    protected Map<String, Definition> copyDefinitionMap(Map<String, Definition> localeDefsMap) {
        LinkedHashMap<String, Definition> retValue = new LinkedHashMap<String, Definition>(localeDefsMap.size());
        for (Map.Entry<String, Definition> entry : localeDefsMap.entrySet()) {
            Definition definition = new Definition(entry.getValue());
            retValue.put(entry.getKey(), definition);
        }
        return retValue;
    }
}

