/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition.dao;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.tiles.Definition;
import org.apache.tiles.definition.DefinitionsFactoryException;
import org.apache.tiles.definition.NoSuchDefinitionException;
import org.apache.tiles.definition.Refreshable;
import org.apache.tiles.definition.dao.BaseLocaleUrlDefinitionDAO;
import org.apache.tiles.definition.pattern.BasicPatternDefinitionResolver;
import org.apache.tiles.definition.pattern.PatternDefinitionResolver;
import org.apache.tiles.definition.pattern.PatternDefinitionResolverAware;
import org.apache.tiles.definition.pattern.wildcard.WildcardDefinitionPatternMatcherFactory;
import org.apache.tiles.util.LocaleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingLocaleUrlDefinitionDAO
extends BaseLocaleUrlDefinitionDAO
implements Refreshable,
PatternDefinitionResolverAware<Locale> {
    public static final String CHECK_REFRESH_INIT_PARAMETER = "org.apache.tiles.definition.dao.LocaleUrlDefinitionDAO.CHECK_REFRESH";
    protected Map<Locale, Map<String, Definition>> locale2definitionMap = new HashMap<Locale, Map<String, Definition>>();
    protected boolean checkRefresh = false;
    protected PatternDefinitionResolver<Locale> definitionResolver;

    @Override
    public void init(Map<String, String> params) {
        super.init(params);
        String param = params.get(CHECK_REFRESH_INIT_PARAMETER);
        this.checkRefresh = "true".equals(param);
        WildcardDefinitionPatternMatcherFactory definitionPatternMatcherFactory = new WildcardDefinitionPatternMatcherFactory();
        this.definitionResolver = new BasicPatternDefinitionResolver<Locale>(definitionPatternMatcherFactory, definitionPatternMatcherFactory);
    }

    @Override
    public void setPatternDefinitionResolver(PatternDefinitionResolver<Locale> definitionResolver) {
        this.definitionResolver = definitionResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Definition getDefinition(String name, Locale customizationKey) {
        Map<String, Definition> definitions;
        Definition retValue = null;
        if (customizationKey == null) {
            customizationKey = LocaleUtil.NULL_LOCALE;
        }
        if ((definitions = this.getDefinitions(customizationKey)) != null && (retValue = definitions.get(name)) == null && (retValue = this.getDefinitionFromResolver(name, customizationKey)) != null) {
            try {
                Map<String, Definition> map = definitions;
                synchronized (map) {
                    definitions.put(name, retValue);
                }
            }
            catch (NoSuchDefinitionException ex) {
                throw new IllegalStateException("Unable to resolve wildcard mapping", (Throwable)((Object)ex));
            }
        }
        return retValue;
    }

    @Override
    public Map<String, Definition> getDefinitions(Locale customizationKey) {
        Map<String, Definition> retValue;
        if (customizationKey == null) {
            customizationKey = LocaleUtil.NULL_LOCALE;
        }
        if ((retValue = this.locale2definitionMap.get(customizationKey)) == null || this.checkRefresh && this.refreshRequired()) {
            retValue = this.checkAndloadDefinitions(customizationKey);
        }
        return retValue;
    }

    @Override
    public synchronized void refresh() {
        if (this.refreshRequired()) {
            this.locale2definitionMap.clear();
        }
    }

    public void setCheckRefresh(boolean checkRefresh) {
        this.checkRefresh = checkRefresh;
    }

    protected Definition getDefinitionFromResolver(String name, Locale customizationKey) {
        return this.definitionResolver.resolveDefinition(name, customizationKey);
    }

    protected synchronized Map<String, Definition> checkAndloadDefinitions(Locale customizationKey) {
        if (this.checkRefresh && this.refreshRequired()) {
            this.locale2definitionMap.clear();
        }
        this.loadDefinitions(customizationKey);
        return this.locale2definitionMap.get(customizationKey);
    }

    protected Map<String, Definition> loadDefinitions(Locale customizationKey) {
        Map<String, Definition> localeDefsMap = this.locale2definitionMap.get(customizationKey);
        if (localeDefsMap != null) {
            return localeDefsMap;
        }
        return this.loadDefinitionsFromURLs(customizationKey);
    }

    protected Map<String, Definition> loadDefinitionsFromURLs(Locale customizationKey) {
        Map<String, Definition> parentDefs;
        String postfix = LocaleUtil.calculatePostfix(customizationKey);
        Locale parentLocale = LocaleUtil.getParentLocale(customizationKey);
        LinkedHashMap<String, Definition> localeDefsMap = new LinkedHashMap<String, Definition>();
        if (parentLocale != null && (parentDefs = this.loadParentDefinitions(parentLocale)) != null) {
            localeDefsMap.putAll(parentDefs);
        }
        for (URL url : this.sourceURLs) {
            String path = url.toExternalForm();
            String newPath = LocaleUtil.concatPostfix(path, postfix);
            try {
                URL newUrl = new URL(newPath);
                Map<String, Definition> defsMap = this.loadDefinitionsFromURL(newUrl);
                if (defsMap == null) continue;
                localeDefsMap.putAll(defsMap);
            }
            catch (MalformedURLException e) {
                throw new DefinitionsFactoryException("Error parsing URL " + newPath, e);
            }
        }
        Map<String, Definition> defsMap = this.definitionResolver.storeDefinitionPatterns(this.copyDefinitionMap(localeDefsMap), customizationKey);
        this.locale2definitionMap.put(customizationKey, defsMap);
        return localeDefsMap;
    }

    protected Map<String, Definition> loadRawDefinitionsFromURLs(Locale customizationKey) {
        return this.loadDefinitionsFromURLs(customizationKey);
    }

    protected Map<String, Definition> loadParentDefinitions(Locale parentLocale) {
        return this.loadDefinitions(parentLocale);
    }

    protected void postDefinitionLoadOperations(Map<String, Definition> localeDefsMap, Locale customizationKey) {
        this.definitionResolver.storeDefinitionPatterns(localeDefsMap, customizationKey);
    }

    protected Map<String, Definition> copyDefinitionMap(Map<String, Definition> localeDefsMap) {
        return localeDefsMap;
    }
}

