/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.joins;

import java.util.HashMap;
import java.util.Map;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.execution.joins.GeneralHashedRelation;
import org.apache.spark.sql.execution.joins.HashedRelation;
import org.apache.spark.sql.execution.joins.UniqueKeyHashedRelation;
import org.apache.spark.sql.execution.joins.UnsafeHashedRelation$;
import org.apache.spark.sql.execution.metric.LongSQLMetric;
import org.apache.spark.util.collection.CompactBuffer;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class HashedRelation$ {
    public static final HashedRelation$ MODULE$;

    static {
        new HashedRelation$();
    }

    public HashedRelation apply(Iterator<InternalRow> input, LongSQLMetric numInputRows, package.Projection keyGenerator, int sizeEstimate) {
        HashedRelation hashedRelation;
        if (keyGenerator instanceof UnsafeProjection) {
            return UnsafeHashedRelation$.MODULE$.apply(input, numInputRows, (UnsafeProjection)keyGenerator, sizeEstimate);
        }
        HashMap<InternalRow, CompactBuffer<InternalRow>> hashTable = new HashMap<InternalRow, CompactBuffer<InternalRow>>(sizeEstimate);
        InternalRow currentRow = null;
        boolean keyIsUnique = true;
        while (input.hasNext()) {
            CompactBuffer compactBuffer;
            BoxedUnit boxedUnit;
            currentRow = (InternalRow)input.next();
            numInputRows.$plus$eq(1L);
            InternalRow rowKey = (InternalRow)keyGenerator.apply((Object)currentRow);
            if (rowKey.anyNull()) {
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            CompactBuffer existingMatchList = hashTable.get(rowKey);
            if (existingMatchList == null) {
                CompactBuffer newMatchList = new CompactBuffer(ClassTag$.MODULE$.apply(InternalRow.class));
                hashTable.put(rowKey.copy(), (CompactBuffer<InternalRow>)newMatchList);
                compactBuffer = newMatchList;
            } else {
                keyIsUnique = false;
                compactBuffer = existingMatchList;
            }
            CompactBuffer matchList = compactBuffer;
            boxedUnit = matchList.$plus$eq((Object)currentRow.copy());
        }
        if (keyIsUnique) {
            HashMap<InternalRow, InternalRow> uniqHashTable = new HashMap<InternalRow, InternalRow>(hashTable.size());
            for (Map.Entry<InternalRow, CompactBuffer<InternalRow>> entry : hashTable.entrySet()) {
                uniqHashTable.put(entry.getKey(), (InternalRow)entry.getValue().apply(0));
            }
            hashedRelation = new UniqueKeyHashedRelation(uniqHashTable);
        } else {
            hashedRelation = new GeneralHashedRelation(hashTable);
        }
        return hashedRelation;
    }

    public int apply$default$4() {
        return 64;
    }

    private HashedRelation$() {
        MODULE$ = this;
    }
}

