/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.common.tools;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import org.apache.hadoop.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliderVersionInfo {
    private static final Logger log = LoggerFactory.getLogger(SliderVersionInfo.class);
    public static final String VERSION_RESOURCE = "org/apache/slider/providers/dynamic/application.properties";
    public static final String APP_NAME = "application.name";
    public static final String APP_VERSION = "application.version";
    public static final String APP_BUILD = "application.build";
    public static final String APP_BUILD_JAVA_VERSION = "application.build.java.version";
    public static final String APP_BUILD_USER = "application.build.user";
    public static final String APP_BUILD_INFO = "application.build.info";
    public static final String HADOOP_BUILD_INFO = "hadoop.build.info";
    public static final String HADOOP_DEPLOYED_INFO = "hadoop.deployed.info";

    public static Properties loadVersionProperties() {
        Properties props = new Properties();
        URL resURL = SliderVersionInfo.class.getClassLoader().getResource(VERSION_RESOURCE);
        assert (resURL != null) : "Null resource org/apache/slider/providers/dynamic/application.properties";
        try {
            InputStream inStream = resURL.openStream();
            assert (inStream != null) : "Null input stream from org/apache/slider/providers/dynamic/application.properties";
            props.load(inStream);
        }
        catch (IOException e) {
            log.warn("IOE loading org/apache/slider/providers/dynamic/application.properties", (Throwable)e);
        }
        return props;
    }

    public static void loadAndPrintVersionInfo(Logger logger) {
        Properties props = SliderVersionInfo.loadVersionProperties();
        logger.info(props.getProperty(APP_BUILD_INFO));
        logger.info("Compiled against Hadoop {}", (Object)props.getProperty(HADOOP_BUILD_INFO));
        logger.info(SliderVersionInfo.getHadoopVersionString());
    }

    public static String getHadoopVersionString() {
        return String.format(Locale.ENGLISH, "Hadoop runtime version %s with source checksum %s and build date %s", VersionInfo.getBranch(), VersionInfo.getSrcChecksum(), VersionInfo.getDate());
    }
}

