/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.client.rest;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.slider.api.SliderApplicationApi;
import org.apache.slider.client.ClientRegistryBinder;
import org.apache.slider.client.rest.SliderApplicationApiRestClient;

public class RestClientFactory {
    private final ClientRegistryBinder binder;
    private final Client jerseyClient;
    private final String user;
    private final String serviceclass;
    private final String instance;

    public RestClientFactory(RegistryOperations operations, Client jerseyClient, String user, String serviceclass, String instance) {
        this.jerseyClient = jerseyClient;
        this.user = user;
        this.serviceclass = serviceclass;
        this.instance = instance;
        this.binder = new ClientRegistryBinder(operations);
    }

    private WebResource locateAppmaster() throws IOException {
        String restAPI = this.binder.lookupExternalRestAPI(this.user, this.serviceclass, this.instance, "classpath:org.apache.slider.client.rest");
        return this.jerseyClient.resource(restAPI);
    }

    public SliderApplicationApi createSliderAppApiClient() throws IOException {
        WebResource appmaster = this.locateAppmaster();
        return this.createSliderAppApiClient(appmaster);
    }

    public SliderApplicationApi createSliderAppApiClient(WebResource appmaster) {
        WebResource appResource = appmaster.path("/ws/v1/slider/application");
        return new SliderApplicationApiRestClient(this.jerseyClient, appResource);
    }
}

