/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.resource.ShardingSphereResource;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.transaction.ShardingSphereTransactionManagerEngine;
import org.apache.shardingsphere.transaction.context.TransactionContexts;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.rule.builder.DefaultTransactionRuleConfigurationBuilder;

public final class TransactionContextsBuilder {
    private final Map<String, ShardingSphereMetaData> metaDataMap;
    private final Collection<ShardingSphereRule> globalRules;

    public TransactionContexts build() {
        HashMap<String, ShardingSphereTransactionManagerEngine> engines = new HashMap<String, ShardingSphereTransactionManagerEngine>(this.metaDataMap.keySet().size(), 1.0f);
        TransactionRule transactionRule = this.getTransactionRule();
        for (String each : this.metaDataMap.keySet()) {
            ShardingSphereTransactionManagerEngine engine = new ShardingSphereTransactionManagerEngine();
            ShardingSphereResource resource = this.metaDataMap.get(each).getResource();
            engine.init(resource.getDatabaseType(), resource.getDataSources(), transactionRule);
            engines.put(each, engine);
        }
        return new TransactionContexts(engines);
    }

    private TransactionRule getTransactionRule() {
        Optional<TransactionRule> transactionRule = this.globalRules.stream().filter(each -> each instanceof TransactionRule).map(each -> (TransactionRule)each).findFirst();
        return transactionRule.orElseGet(() -> new TransactionRule(new DefaultTransactionRuleConfigurationBuilder().build()));
    }

    @Generated
    public TransactionContextsBuilder(Map<String, ShardingSphereMetaData> metaDataMap, Collection<ShardingSphereRule> globalRules) {
        this.metaDataMap = metaDataMap;
        this.globalRules = globalRules;
    }
}

