/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.transaction.context.TransactionContexts;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.apache.shardingsphere.transaction.core.TransactionTypeHolder;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.spi.ShardingSphereTransactionManager;

public final class ConnectionTransaction {
    private final TransactionType transactionType;
    private volatile boolean rollbackOnly;
    private final ShardingSphereTransactionManager transactionManager;

    public ConnectionTransaction(String schemaName, TransactionContexts transactionContexts) {
        this(schemaName, TransactionType.LOCAL, transactionContexts);
    }

    public ConnectionTransaction(String schemaName, TransactionRule rule, TransactionContexts transactionContexts) {
        this(schemaName, rule.getDefaultType(), transactionContexts);
    }

    public ConnectionTransaction(String schemaName, TransactionType transactionType, TransactionContexts transactionContexts) {
        this.transactionType = transactionType;
        this.transactionManager = transactionContexts.getEngines().get(schemaName).getTransactionManager(transactionType);
        TransactionTypeHolder.set(transactionType);
    }

    public boolean isInTransaction() {
        return null != this.transactionManager && this.transactionManager.isInTransaction();
    }

    public boolean isLocalTransaction() {
        return TransactionType.LOCAL == this.transactionType;
    }

    public boolean isHoldTransaction(boolean autoCommit) {
        return TransactionType.LOCAL == this.transactionType && !autoCommit || TransactionType.XA == this.transactionType && this.isInTransaction();
    }

    public Optional<Connection> getConnection(String dataSourceName) throws SQLException {
        return this.isInTransaction() ? Optional.of(this.transactionManager.getConnection(dataSourceName)) : Optional.empty();
    }

    public void begin() {
        this.transactionManager.begin();
    }

    public void commit() {
        this.transactionManager.commit(this.rollbackOnly);
    }

    public void rollback() {
        this.transactionManager.rollback();
    }

    public DistributedTransactionOperationType getDistributedTransactionOperationType(boolean autoCommit) {
        if (!autoCommit && !this.transactionManager.isInTransaction()) {
            return DistributedTransactionOperationType.BEGIN;
        }
        if (autoCommit && this.transactionManager.isInTransaction()) {
            return DistributedTransactionOperationType.COMMIT;
        }
        return DistributedTransactionOperationType.IGNORE;
    }

    @Generated
    public void setRollbackOnly(boolean rollbackOnly) {
        this.rollbackOnly = rollbackOnly;
    }

    @Generated
    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    public static enum DistributedTransactionOperationType {
        BEGIN,
        COMMIT,
        IGNORE;

    }
}

