/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.traffic.engine;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.instance.definition.InstanceId;
import org.apache.shardingsphere.infra.instance.definition.InstanceType;
import org.apache.shardingsphere.traffic.context.TrafficContext;
import org.apache.shardingsphere.traffic.rule.TrafficRule;
import org.apache.shardingsphere.traffic.rule.TrafficStrategyRule;
import org.apache.shardingsphere.traffic.spi.TrafficLoadBalanceAlgorithm;

public final class TrafficEngine {
    private final TrafficRule trafficRule;
    private final InstanceContext instanceContext;

    public TrafficContext dispatch(LogicSQL logicSQL, boolean inTransaction) {
        Optional<TrafficStrategyRule> strategyRule = this.trafficRule.findMatchedStrategyRule(logicSQL, inTransaction);
        TrafficContext result = new TrafficContext();
        if (!strategyRule.isPresent() || this.isInvalidStrategyRule(strategyRule.get())) {
            return result;
        }
        List instanceIds = this.instanceContext.getComputeNodeInstanceIds(InstanceType.PROXY, strategyRule.get().getLabels());
        if (!instanceIds.isEmpty()) {
            TrafficLoadBalanceAlgorithm loadBalancer = strategyRule.get().getLoadBalancer();
            InstanceId instanceId = 1 == instanceIds.size() ? (InstanceId)instanceIds.iterator().next() : loadBalancer.getInstanceId(strategyRule.get().getName(), instanceIds);
            result.setInstanceId(instanceId.getId());
        }
        return result;
    }

    private boolean isInvalidStrategyRule(TrafficStrategyRule strategyRule) {
        return strategyRule.getLabels().isEmpty() || null == strategyRule.getLoadBalancer();
    }

    @Generated
    public TrafficEngine(TrafficRule trafficRule, InstanceContext instanceContext) {
        this.trafficRule = trafficRule;
        this.instanceContext = instanceContext;
    }
}

