/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.traffic.algorithm.loadbalance;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shardingsphere.infra.instance.definition.InstanceId;
import org.apache.shardingsphere.traffic.spi.TrafficLoadBalanceAlgorithm;

public final class RoundRobinTrafficLoadBalanceAlgorithm
implements TrafficLoadBalanceAlgorithm {
    private static final ConcurrentHashMap<String, AtomicInteger> COUNTS = new ConcurrentHashMap();

    public InstanceId getInstanceId(String name, List<InstanceId> instanceIds) {
        AtomicInteger count = COUNTS.containsKey(name) ? COUNTS.get(name) : new AtomicInteger(0);
        COUNTS.putIfAbsent(name, count);
        count.compareAndSet(instanceIds.size(), 0);
        return instanceIds.get(Math.abs(count.getAndIncrement()) % instanceIds.size());
    }

    public String getType() {
        return "ROUND_ROBIN";
    }

    public boolean isDefault() {
        return true;
    }
}

