/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.standalone;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.infra.config.mode.PersistRepositoryConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.schema.SchemaConfiguration;
import org.apache.shardingsphere.infra.config.schema.impl.DataSourceProvidedSchemaConfiguration;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.instance.definition.InstanceType;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.rule.identifier.type.InstanceAwareRule;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilder;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.manager.standalone.lock.StandaloneLockContext;
import org.apache.shardingsphere.mode.manager.standalone.workerid.generator.StandaloneWorkerIdGenerator;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsBuilder;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;
import org.apache.shardingsphere.mode.repository.standalone.StandalonePersistRepositoryFactory;
import org.apache.shardingsphere.transaction.context.TransactionContexts;
import org.apache.shardingsphere.transaction.context.TransactionContextsBuilder;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.spi.TransactionConfigurationFileGeneratorFactory;

public final class StandaloneContextManagerBuilder
implements ContextManagerBuilder {
    public ContextManager build(ContextManagerBuilderParameter parameter) throws SQLException {
        MetaDataPersistService metaDataPersistService = new MetaDataPersistService((PersistRepository)StandalonePersistRepositoryFactory.newInstance((PersistRepositoryConfiguration)parameter.getModeConfig().getRepository()));
        this.persistConfigurations(metaDataPersistService, parameter);
        MetaDataContexts metaDataContexts = this.createMetaDataContexts(metaDataPersistService, parameter);
        return this.createContextManager(metaDataPersistService, parameter, metaDataContexts);
    }

    private void persistConfigurations(MetaDataPersistService metaDataPersistService, ContextManagerBuilderParameter parameter) {
        if (!parameter.isEmpty()) {
            metaDataPersistService.persistConfigurations(parameter.getSchemaConfigs(), parameter.getGlobalRuleConfigs(), parameter.getProps(), parameter.getModeConfig().isOverwrite());
        }
    }

    private MetaDataContexts createMetaDataContexts(MetaDataPersistService metaDataPersistService, ContextManagerBuilderParameter parameter) throws SQLException {
        Collection globalRuleConfigs = metaDataPersistService.getGlobalRuleService().load();
        Properties props = metaDataPersistService.getPropsService().load();
        MetaDataContextsBuilder builder = new MetaDataContextsBuilder(globalRuleConfigs, props);
        Collection<Object> schemaNames = InstanceType.JDBC == parameter.getInstanceDefinition().getInstanceType() ? parameter.getSchemaConfigs().keySet() : metaDataPersistService.getSchemaMetaDataService().loadAllNames();
        DatabaseType databaseType = DatabaseTypeFactory.getDatabaseType((Map)parameter.getSchemaConfigs(), (ConfigurationProperties)new ConfigurationProperties(parameter.getProps()));
        for (String string : schemaNames) {
            if (databaseType.getSystemSchemas().contains(string)) continue;
            builder.addSchema(string, databaseType, this.createSchemaConfiguration(string, metaDataPersistService, parameter), props);
        }
        builder.addSystemSchemas(databaseType);
        return builder.build(metaDataPersistService);
    }

    private SchemaConfiguration createSchemaConfiguration(String schemaName, MetaDataPersistService metaDataPersistService, ContextManagerBuilderParameter parameter) {
        Map dataSources = metaDataPersistService.getEffectiveDataSources(schemaName, parameter.getSchemaConfigs());
        Collection schemaRuleConfigs = metaDataPersistService.getSchemaRuleService().load(schemaName);
        return new DataSourceProvidedSchemaConfiguration(dataSources, schemaRuleConfigs);
    }

    private ContextManager createContextManager(MetaDataPersistService metaDataPersistService, ContextManagerBuilderParameter parameter, MetaDataContexts metaDataContexts) {
        ContextManager result = new ContextManager();
        InstanceContext instanceContext = new InstanceContext(metaDataPersistService.getComputeNodePersistService().loadComputeNodeInstance(parameter.getInstanceDefinition()), (WorkerIdGenerator)new StandaloneWorkerIdGenerator(), parameter.getModeConfig(), (LockContext)new StandaloneLockContext());
        this.generateTransactionConfigurationFile(instanceContext, metaDataContexts);
        TransactionContexts transactionContexts = new TransactionContextsBuilder(metaDataContexts.getMetaDataMap(), metaDataContexts.getGlobalRuleMetaData().getRules()).build();
        result.init(metaDataContexts, transactionContexts, instanceContext);
        this.setInstanceContext(result);
        return result;
    }

    private void generateTransactionConfigurationFile(InstanceContext instanceContext, MetaDataContexts metaDataContexts) {
        Optional<TransactionRule> transactionRule = metaDataContexts.getGlobalRuleMetaData().getRules().stream().filter(each -> each instanceof TransactionRule).map(each -> (TransactionRule)each).findFirst();
        if (transactionRule.isPresent()) {
            Optional fileGenerator = TransactionConfigurationFileGeneratorFactory.newInstance((String)transactionRule.get().getProviderType());
            fileGenerator.ifPresent(optional -> optional.generateFile(((TransactionRule)transactionRule.get()).getProps(), instanceContext));
        }
    }

    private void setInstanceContext(ContextManager contextManager) {
        contextManager.getMetaDataContexts().getMetaDataMap().forEach((key, value) -> value.getRuleMetaData().getRules().stream().filter(each -> each instanceof InstanceAwareRule).forEach(each -> ((InstanceAwareRule)each).setInstanceContext(contextManager.getInstanceContext())));
    }

    public String getType() {
        return "Standalone";
    }
}

