/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.rule;

import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereData;
import org.apache.shardingsphere.infra.rule.identifier.scope.GlobalRule;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.sqlfederation.api.config.SQLFederationRuleConfiguration;
import org.apache.shardingsphere.sqlfederation.factory.SQLFederationExecutorFactory;
import org.apache.shardingsphere.sqlfederation.spi.SQLFederationExecutor;

public final class SQLFederationRule
implements GlobalRule {
    private final SQLFederationRuleConfiguration configuration;
    private final SQLFederationExecutor sqlFederationExecutor;

    public SQLFederationRule(SQLFederationRuleConfiguration ruleConfig) {
        this.configuration = ruleConfig;
        this.sqlFederationExecutor = SQLFederationExecutorFactory.getInstance((String)ruleConfig.getSqlFederationType());
    }

    public SQLFederationExecutor getSQLFederationExecutor(String databaseName, String schemaName, ShardingSphereMetaData metaData, ShardingSphereData shardingSphereData, JDBCExecutor jdbcExecutor, EventBusContext eventBusContext) {
        this.sqlFederationExecutor.init(databaseName, schemaName, metaData, shardingSphereData, jdbcExecutor, eventBusContext);
        return this.sqlFederationExecutor;
    }

    public String getType() {
        return SQLFederationRule.class.getSimpleName();
    }

    @Generated
    public SQLFederationRuleConfiguration getConfiguration() {
        return this.configuration;
    }
}

