/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.singletable.route.engine;

import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.singletable.route.engine.SingleTableDatabaseBroadcastRouteEngine;
import org.apache.shardingsphere.singletable.route.engine.SingleTableRouteEngine;
import org.apache.shardingsphere.singletable.route.engine.SingleTableStandardRouteEngine;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterSchemaStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateSchemaStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropSchemaStatement;

public final class SingleTableRouteEngineFactory {
    public static Optional<SingleTableRouteEngine> newInstance(Collection<QualifiedTable> singleTableNames, SQLStatement sqlStatement) {
        if (!singleTableNames.isEmpty()) {
            return Optional.of(new SingleTableStandardRouteEngine(singleTableNames, sqlStatement));
        }
        if (SingleTableRouteEngineFactory.isSchemaDDLStatement(sqlStatement)) {
            return Optional.of(new SingleTableDatabaseBroadcastRouteEngine());
        }
        return Optional.empty();
    }

    private static boolean isSchemaDDLStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof CreateSchemaStatement || sqlStatement instanceof AlterSchemaStatement || sqlStatement instanceof DropSchemaStatement;
    }

    @Generated
    private SingleTableRouteEngineFactory() {
    }
}

