/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.singletable.metadata;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.spi.RuleBasedSchemaMetaDataDecorator;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.ConstraintMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.IndexMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.SchemaMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.TableMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtil;
import org.apache.shardingsphere.singletable.rule.SingleTableRule;

public final class SingleTableSchemaMetaDataDecorator
implements RuleBasedSchemaMetaDataDecorator<SingleTableRule> {
    public Map<String, SchemaMetaData> decorate(Map<String, SchemaMetaData> schemaMetaDataMap, SingleTableRule rule, GenericSchemaBuilderMaterials materials) {
        LinkedHashMap<String, SchemaMetaData> result = new LinkedHashMap<String, SchemaMetaData>();
        for (Map.Entry<String, SchemaMetaData> entry : schemaMetaDataMap.entrySet()) {
            LinkedList<TableMetaData> tables = new LinkedList<TableMetaData>();
            for (TableMetaData each : entry.getValue().getTables()) {
                tables.add(this.decorate(each.getName(), each));
            }
            result.put(entry.getKey(), new SchemaMetaData(entry.getKey(), tables));
        }
        return result;
    }

    private TableMetaData decorate(String tableName, TableMetaData tableMetaData) {
        return new TableMetaData(tableName, tableMetaData.getColumns(), this.getIndex(tableMetaData), this.getConstraint(tableMetaData));
    }

    private Collection<IndexMetaData> getIndex(TableMetaData tableMetaData) {
        return tableMetaData.getIndexes().stream().map(each -> new IndexMetaData(IndexMetaDataUtil.getLogicIndexName((String)each.getName(), (String)tableMetaData.getName()))).collect(Collectors.toList());
    }

    private Collection<ConstraintMetaData> getConstraint(TableMetaData tableMetaData) {
        return tableMetaData.getConstrains().stream().map(each -> new ConstraintMetaData(IndexMetaDataUtil.getLogicIndexName((String)each.getName(), (String)tableMetaData.getName()), each.getReferencedTableName())).collect(Collectors.toList());
    }

    public int getOrder() {
        return 0;
    }

    public Class<SingleTableRule> getTypeClass() {
        return SingleTableRule.class;
    }
}

