/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.singletable.rule;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.schema.loader.common.SchemaMetaDataLoader;

public final class SingleTableDataNodeLoader {
    public static Map<String, Collection<DataNode>> load(DatabaseType databaseType, Map<String, DataSource> dataSourceMap, Collection<String> excludedTables, ConfigurationProperties props) {
        ConcurrentHashMap<String, Collection<DataNode>> result = new ConcurrentHashMap<String, Collection<DataNode>>();
        boolean checkDuplicateTable = (Boolean)props.getValue((Enum)ConfigurationPropertyKey.CHECK_DUPLICATE_TABLE_ENABLED);
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            Map<String, DataNode> dataNodeMap = SingleTableDataNodeLoader.load(databaseType, entry.getKey(), entry.getValue(), excludedTables);
            for (String each : dataNodeMap.keySet()) {
                Collection existDataNode = result.putIfAbsent(each.toLowerCase(), Collections.singletonList(dataNodeMap.get(each)));
                if (!checkDuplicateTable) continue;
                Preconditions.checkState((null == existDataNode ? 1 : 0) != 0, (String)"Single table conflict, there are multiple tables `%s` existed.", (Object)each);
            }
        }
        return result;
    }

    private static Map<String, DataNode> load(DatabaseType databaseType, String dataSourceName, DataSource dataSource, Collection<String> excludedTables) {
        Collection<String> tables = SingleTableDataNodeLoader.loadAllTableNames(databaseType, dataSource);
        HashMap<String, DataNode> result = new HashMap<String, DataNode>(tables.size(), 1.0f);
        for (String each : tables) {
            if (excludedTables.contains(each)) continue;
            result.put(each, new DataNode(dataSourceName, each));
        }
        return result;
    }

    private static Collection<String> loadAllTableNames(DatabaseType databaseType, DataSource dataSource) {
        try {
            return SchemaMetaDataLoader.loadAllTableNames((DatabaseType)databaseType, (DataSource)dataSource);
        }
        catch (SQLException ex) {
            throw new ShardingSphereConfigurationException("Can not load table: %s", new Object[]{ex.getMessage()});
        }
    }

    @Generated
    private SingleTableDataNodeLoader() {
    }
}

