/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.singletable.route;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.singletable.rule.SingleTableRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterTableStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropTableStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class SingleTableRouteEngine {
    private final Collection<String> singleTableNames;
    private final SQLStatement sqlStatement;

    public void route(RouteContext routeContext, SingleTableRule rule) {
        if (routeContext.getRouteUnits().isEmpty() || this.sqlStatement instanceof SelectStatement) {
            this.route0(routeContext, rule);
        } else {
            RouteContext newRouteContext = new RouteContext();
            this.route0(newRouteContext, rule);
            this.combineRouteContext(routeContext, newRouteContext);
        }
    }

    private void combineRouteContext(RouteContext routeContext, RouteContext newRouteContext) {
        Map<String, RouteUnit> dataSourceRouteUnits = this.getDataSourceRouteUnits(newRouteContext);
        routeContext.getRouteUnits().removeIf(each -> !dataSourceRouteUnits.containsKey(each.getDataSourceMapper().getLogicName()));
        for (Map.Entry<String, RouteUnit> entry : dataSourceRouteUnits.entrySet()) {
            routeContext.putRouteUnit(entry.getValue().getDataSourceMapper(), entry.getValue().getTableMappers());
        }
    }

    private Map<String, RouteUnit> getDataSourceRouteUnits(RouteContext newRouteContext) {
        return newRouteContext.getRouteUnits().stream().collect(Collectors.toMap(each -> each.getDataSourceMapper().getLogicName(), Function.identity(), (oldValue, currentValue) -> oldValue));
    }

    private void route0(RouteContext routeContext, SingleTableRule rule) {
        if (this.isDDLTableStatement() || rule.isAllTablesInSameDataSource(routeContext, this.singleTableNames)) {
            Collection<String> existSingleTables = rule.getSingleTableNames(this.singleTableNames);
            if (!existSingleTables.isEmpty()) {
                this.fillRouteContext(rule, routeContext, existSingleTables);
            } else {
                RouteUnit routeUnit = rule.getDefaultDataSource().isPresent() ? this.getDefaultRouteUnit(rule.getDefaultDataSource().get()) : this.getRandomRouteUnit(rule);
                routeContext.getRouteUnits().add(routeUnit);
            }
        } else {
            this.decorateRouteContextForFederate(routeContext);
            this.fillRouteContext(rule, routeContext, this.singleTableNames);
        }
    }

    private void decorateRouteContextForFederate(RouteContext routeContext) {
        RouteContext newRouteContext = new RouteContext();
        for (RouteUnit each : routeContext.getRouteUnits()) {
            newRouteContext.putRouteUnit(each.getDataSourceMapper(), each.getTableMappers());
        }
        routeContext.setFederated(true);
        routeContext.getRouteUnits().clear();
        routeContext.getOriginalDataNodes().clear();
        routeContext.getRouteUnits().addAll(newRouteContext.getRouteUnits());
        routeContext.getOriginalDataNodes().addAll(newRouteContext.getOriginalDataNodes());
    }

    private boolean isDDLTableStatement() {
        return this.sqlStatement instanceof CreateTableStatement || this.sqlStatement instanceof AlterTableStatement || this.sqlStatement instanceof DropTableStatement;
    }

    private RouteUnit getRandomRouteUnit(SingleTableRule singleTableRule) {
        Collection<String> dataSourceNames = singleTableRule.getDataSourceNames();
        String dataSource = new ArrayList<String>(dataSourceNames).get(ThreadLocalRandom.current().nextInt(dataSourceNames.size()));
        String table = this.singleTableNames.iterator().next();
        return new RouteUnit(new RouteMapper(dataSource, dataSource), Collections.singleton(new RouteMapper(table, table)));
    }

    private RouteUnit getDefaultRouteUnit(String dataSource) {
        String table = this.singleTableNames.iterator().next();
        return new RouteUnit(new RouteMapper(dataSource, dataSource), Collections.singleton(new RouteMapper(table, table)));
    }

    private void fillRouteContext(SingleTableRule singleTableRule, RouteContext routeContext, Collection<String> logicTables) {
        for (String each : logicTables) {
            Optional<DataNode> dataNode = singleTableRule.findSingleTableDataNode(each);
            if (!dataNode.isPresent()) {
                throw new ShardingSphereException("`%s` single table does not exist.", new Object[]{each});
            }
            String dataSource = dataNode.get().getDataSourceName();
            routeContext.putRouteUnit(new RouteMapper(dataSource, dataSource), Collections.singletonList(new RouteMapper(each, each)));
        }
    }

    @Generated
    public SingleTableRouteEngine(Collection<String> singleTableNames, SQLStatement sqlStatement) {
        this.singleTableNames = singleTableNames;
        this.sqlStatement = sqlStatement;
    }
}

