/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.singletable.metadata;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.builder.spi.RuleBasedTableMetaDataBuilder;
import org.apache.shardingsphere.infra.metadata.schema.loader.TableMetaDataLoaderEngine;
import org.apache.shardingsphere.infra.metadata.schema.model.ConstraintMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.IndexMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.metadata.schema.util.IndexMetaDataUtil;
import org.apache.shardingsphere.infra.metadata.schema.util.TableMetaDataUtil;
import org.apache.shardingsphere.singletable.rule.SingleTableRule;

public final class SingleTableMetaDataBuilder
implements RuleBasedTableMetaDataBuilder<SingleTableRule> {
    public Map<String, TableMetaData> load(Collection<String> tableNames, SingleTableRule rule, SchemaBuilderMaterials materials) throws SQLException {
        Collection needLoadTables = tableNames.stream().filter(each -> rule.getTables().contains(each)).collect(Collectors.toSet());
        if (needLoadTables.isEmpty()) {
            return Collections.emptyMap();
        }
        Collection tableMetaDataLoaderMaterials = TableMetaDataUtil.getTableMetaDataLoadMaterial((Collection)needLoadTables, (SchemaBuilderMaterials)materials, (boolean)false);
        if (tableMetaDataLoaderMaterials.isEmpty()) {
            return Collections.emptyMap();
        }
        Collection tableMetaDataList = TableMetaDataLoaderEngine.load((Collection)tableMetaDataLoaderMaterials, (DatabaseType)materials.getDatabaseType());
        return tableMetaDataList.stream().collect(Collectors.toMap(TableMetaData::getName, Function.identity(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    public Map<String, TableMetaData> decorate(Map<String, TableMetaData> tableMetaDataMap, SingleTableRule rule, SchemaBuilderMaterials materials) {
        LinkedHashMap<String, TableMetaData> result = new LinkedHashMap<String, TableMetaData>();
        for (Map.Entry<String, TableMetaData> entry : tableMetaDataMap.entrySet()) {
            result.put(entry.getKey(), this.decorate(entry.getKey(), entry.getValue(), rule));
        }
        return result;
    }

    private TableMetaData decorate(String tableName, TableMetaData tableMetaData, SingleTableRule rule) {
        return rule.getTables().contains(tableName) ? new TableMetaData(tableName, tableMetaData.getColumns().values(), this.getIndex(tableMetaData), this.getConstraint(tableMetaData)) : tableMetaData;
    }

    private Collection<IndexMetaData> getIndex(TableMetaData tableMetaData) {
        return tableMetaData.getIndexes().values().stream().map(each -> new IndexMetaData(IndexMetaDataUtil.getLogicIndexName((String)each.getName(), (String)tableMetaData.getName()))).collect(Collectors.toList());
    }

    private Collection<ConstraintMetaData> getConstraint(TableMetaData tableMetaData) {
        return tableMetaData.getConstrains().values().stream().map(each -> new ConstraintMetaData(IndexMetaDataUtil.getLogicIndexName((String)each.getName(), (String)tableMetaData.getName()), each.getReferencedTableName())).collect(Collectors.toList());
    }

    public int getOrder() {
        return 0;
    }

    public Class<SingleTableRule> getTypeClass() {
        return SingleTableRule.class;
    }
}

