/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.schedule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.spi.rulealtered.RuleAlteredDetector;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rulealtered.OnRuleAlteredActionConfiguration;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.rulealtered.YamlOnRuleAlteredActionConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rulealtered.OnRuleAlteredActionConfigurationYamlSwapper;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;
import org.apache.shardingsphere.sharding.yaml.config.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.rule.YamlShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.rule.YamlTableRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.ShardingRuleConfigurationYamlSwapper;

public final class ShardingRuleAlteredDetector
implements RuleAlteredDetector {
    private static final ShardingRuleConfigurationYamlSwapper SHARDING_RULE_CONFIG_YAML_SWAPPER = new ShardingRuleConfigurationYamlSwapper();
    private static final OnRuleAlteredActionConfigurationYamlSwapper RULE_ALTERED_ACTION_CONFIG_YAML_SWAPPER = new OnRuleAlteredActionConfigurationYamlSwapper();

    public String getYamlRuleConfigClassName() {
        return YamlShardingRuleConfiguration.class.getName();
    }

    public String getRuleConfigClassName() {
        return ShardingRuleConfiguration.class.getName();
    }

    public List<String> findRuleAlteredLogicTables(YamlRuleConfiguration sourceRuleConfig, YamlRuleConfiguration targetRuleConfig, Map<String, Map<String, Object>> sourceDataSources, Map<String, Map<String, Object>> targetDataSources) {
        if (null == sourceRuleConfig ^ null == targetRuleConfig) {
            YamlRuleConfiguration ruleConfig = null != sourceRuleConfig ? sourceRuleConfig : targetRuleConfig;
            return this.extractAllLogicTables((YamlShardingRuleConfiguration)ruleConfig);
        }
        if (null == sourceRuleConfig) {
            return Collections.emptyList();
        }
        if (this.isShardingRulesTheSame((YamlShardingRuleConfiguration)sourceRuleConfig, (YamlShardingRuleConfiguration)targetRuleConfig)) {
            return Collections.emptyList();
        }
        ShardingRuleConfiguration sourceShardingConfig = SHARDING_RULE_CONFIG_YAML_SWAPPER.swapToObject((YamlShardingRuleConfiguration)sourceRuleConfig);
        ShardingRuleConfiguration targetShardingConfig = SHARDING_RULE_CONFIG_YAML_SWAPPER.swapToObject((YamlShardingRuleConfiguration)targetRuleConfig);
        ShardingRule sourceShardingRule = new ShardingRule(sourceShardingConfig, sourceDataSources.keySet());
        ShardingRule targetShardingRule = new ShardingRule(targetShardingConfig, targetDataSources.keySet());
        return this.extractRuleAlteredLogicTables(sourceShardingRule, targetShardingRule);
    }

    private List<String> extractAllLogicTables(YamlShardingRuleConfiguration shardingRuleConfig) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(shardingRuleConfig.getTables().keySet());
        result.addAll(shardingRuleConfig.getAutoTables().keySet());
        return result;
    }

    private boolean isShardingRulesTheSame(YamlShardingRuleConfiguration sourceShardingConfig, YamlShardingRuleConfiguration targetShardingConfig) {
        for (Map.Entry<String, YamlTableRuleConfiguration> entry : sourceShardingConfig.getTables().entrySet()) {
            entry.getValue().setLogicTable(null);
        }
        for (Map.Entry<String, YamlTableRuleConfiguration> entry : targetShardingConfig.getTables().entrySet()) {
            entry.getValue().setLogicTable(null);
        }
        for (Map.Entry<String, Object> entry : sourceShardingConfig.getAutoTables().entrySet()) {
            ((YamlShardingAutoTableRuleConfiguration)entry.getValue()).setLogicTable(null);
        }
        for (Map.Entry<String, Object> entry : targetShardingConfig.getAutoTables().entrySet()) {
            ((YamlShardingAutoTableRuleConfiguration)entry.getValue()).setLogicTable(null);
        }
        String sourceShardingConfigYaml = YamlEngine.marshal((Object)sourceShardingConfig);
        String string = YamlEngine.marshal((Object)targetShardingConfig);
        return sourceShardingConfigYaml.equals(string);
    }

    private List<String> extractRuleAlteredLogicTables(ShardingRule sourceShardingRule, ShardingRule targetShardingRule) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, TableRule> entry : sourceShardingRule.getTableRules().entrySet()) {
            TableRule targetTableRule = targetShardingRule.getTableRule(entry.getKey());
            if (!this.doesLogicTableNeedReSharding(entry.getValue(), targetTableRule)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private boolean doesLogicTableNeedReSharding(TableRule sourceTableRule, TableRule targetTableRule) {
        List<DataNode> sourceActualDataNodes = sourceTableRule.getActualDataNodes();
        List<DataNode> targetActualDataNodes = targetTableRule.getActualDataNodes();
        if (sourceActualDataNodes.size() == targetActualDataNodes.size() && sourceActualDataNodes.equals(targetActualDataNodes)) {
            return false;
        }
        if (this.hasCommonDataSourceNames(sourceActualDataNodes, targetActualDataNodes)) {
            throw new RuntimeException("Scale on source dataSources is not supported for now");
        }
        return true;
    }

    private boolean hasCommonDataSourceNames(List<DataNode> sourceActualDataNodes, List<DataNode> targetActualDataNodes) {
        Set sourceDataSourceNames = sourceActualDataNodes.stream().map(each -> each.getDataSourceName().toLowerCase()).collect(Collectors.toSet());
        Set targetDataSourceNames = targetActualDataNodes.stream().map(each -> each.getDataSourceName().toLowerCase()).collect(Collectors.toSet());
        for (String each2 : sourceDataSourceNames) {
            if (!targetDataSourceNames.contains(each2)) continue;
            return true;
        }
        return false;
    }

    public Optional<OnRuleAlteredActionConfiguration> getOnRuleAlteredActionConfig(RuleConfiguration ruleConfig) {
        if (null == ruleConfig) {
            return Optional.empty();
        }
        ShardingRuleConfiguration shardingRuleConfig = (ShardingRuleConfiguration)ruleConfig;
        String scalingName = shardingRuleConfig.getScalingName();
        if (null == scalingName) {
            return Optional.empty();
        }
        OnRuleAlteredActionConfiguration result = (OnRuleAlteredActionConfiguration)shardingRuleConfig.getScaling().get(scalingName);
        if (null == result) {
            YamlOnRuleAlteredActionConfiguration yamlConfig = new YamlOnRuleAlteredActionConfiguration();
            result = RULE_ALTERED_ACTION_CONFIG_YAML_SWAPPER.swapToObject(yamlConfig);
        }
        return Optional.of(result);
    }
}

