/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datanode.DataNodeInfo;
import org.apache.shardingsphere.infra.datanode.DataNodeUtil;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.support.InlineExpressionParser;

public final class TableRule {
    private static final Pattern DATA_NODE_SUFFIX_PATTERN = Pattern.compile("\\d+$");
    private static final char DEFAULT_PADDING_CHAR = '0';
    private final String logicTable;
    private final List<DataNode> actualDataNodes;
    private final Set<String> actualTables;
    private final Map<DataNode, Integer> dataNodeIndexMap;
    private final ShardingStrategyConfiguration databaseShardingStrategyConfig;
    private final ShardingStrategyConfiguration tableShardingStrategyConfig;
    private final String generateKeyColumn;
    private final String keyGeneratorName;
    private final Collection<String> actualDatasourceNames = new LinkedHashSet<String>();
    private final Map<String, Collection<String>> datasourceToTablesMap = new HashMap<String, Collection<String>>();
    private final DataNodeInfo dataSourceDataNode;
    private final DataNodeInfo tableDataNode;

    public TableRule(Collection<String> dataSourceNames, String logicTableName) {
        this.logicTable = logicTableName;
        this.dataNodeIndexMap = new HashMap<DataNode, Integer>(dataSourceNames.size(), 1.0f);
        this.actualDataNodes = this.generateDataNodes(logicTableName, dataSourceNames);
        this.actualTables = this.getActualTables();
        this.databaseShardingStrategyConfig = null;
        this.tableShardingStrategyConfig = null;
        this.generateKeyColumn = null;
        this.keyGeneratorName = null;
        this.dataSourceDataNode = this.actualDataNodes.isEmpty() ? null : this.createDataSourceDataNode(this.actualDataNodes);
        this.tableDataNode = this.actualDataNodes.isEmpty() ? null : this.createTableDataNode(this.actualDataNodes);
    }

    public TableRule(ShardingTableRuleConfiguration tableRuleConfig, Collection<String> dataSourceNames, String defaultGenerateKeyColumn) {
        this.logicTable = tableRuleConfig.getLogicTable();
        List dataNodes = new InlineExpressionParser(tableRuleConfig.getActualDataNodes()).splitAndEvaluate();
        this.dataNodeIndexMap = new HashMap<DataNode, Integer>(dataNodes.size(), 1.0f);
        this.actualDataNodes = this.isEmptyDataNodes(dataNodes) ? this.generateDataNodes(tableRuleConfig.getLogicTable(), dataSourceNames) : this.generateDataNodes(dataNodes, dataSourceNames);
        this.actualTables = this.getActualTables();
        this.databaseShardingStrategyConfig = tableRuleConfig.getDatabaseShardingStrategy();
        this.tableShardingStrategyConfig = tableRuleConfig.getTableShardingStrategy();
        KeyGenerateStrategyConfiguration keyGeneratorConfig = tableRuleConfig.getKeyGenerateStrategy();
        this.generateKeyColumn = null != keyGeneratorConfig && !Strings.isNullOrEmpty((String)keyGeneratorConfig.getColumn()) ? keyGeneratorConfig.getColumn() : defaultGenerateKeyColumn;
        this.keyGeneratorName = null == keyGeneratorConfig ? null : keyGeneratorConfig.getKeyGeneratorName();
        this.dataSourceDataNode = this.actualDataNodes.isEmpty() ? null : this.createDataSourceDataNode(this.actualDataNodes);
        this.tableDataNode = this.actualDataNodes.isEmpty() ? null : this.createTableDataNode(this.actualDataNodes);
        this.checkRule(dataNodes);
    }

    public TableRule(ShardingAutoTableRuleConfiguration tableRuleConfig, Collection<String> dataSourceNames, ShardingAutoTableAlgorithm shardingAutoTableAlgorithm, String defaultGenerateKeyColumn) {
        this.logicTable = tableRuleConfig.getLogicTable();
        this.databaseShardingStrategyConfig = new NoneShardingStrategyConfiguration();
        this.tableShardingStrategyConfig = tableRuleConfig.getShardingStrategy();
        List<String> dataNodes = this.getDataNodes(tableRuleConfig, shardingAutoTableAlgorithm, dataSourceNames);
        this.dataNodeIndexMap = new HashMap<DataNode, Integer>(dataNodes.size(), 1.0f);
        this.actualDataNodes = this.isEmptyDataNodes(dataNodes) ? this.generateDataNodes(tableRuleConfig.getLogicTable(), dataSourceNames) : this.generateDataNodes(dataNodes, dataSourceNames);
        this.actualTables = this.getActualTables();
        KeyGenerateStrategyConfiguration keyGeneratorConfig = tableRuleConfig.getKeyGenerateStrategy();
        this.generateKeyColumn = null != keyGeneratorConfig && !Strings.isNullOrEmpty((String)keyGeneratorConfig.getColumn()) ? keyGeneratorConfig.getColumn() : defaultGenerateKeyColumn;
        this.keyGeneratorName = null == keyGeneratorConfig ? null : keyGeneratorConfig.getKeyGeneratorName();
        this.dataSourceDataNode = this.actualDataNodes.isEmpty() ? null : this.createDataSourceDataNode(this.actualDataNodes);
        this.tableDataNode = this.actualDataNodes.isEmpty() ? null : this.createTableDataNode(this.actualDataNodes);
        this.checkRule(dataNodes);
    }

    private DataNodeInfo createDataSourceDataNode(Collection<DataNode> actualDataNodes) {
        String prefix = DATA_NODE_SUFFIX_PATTERN.matcher(actualDataNodes.iterator().next().getDataSourceName()).replaceAll("");
        int suffixMinLength = actualDataNodes.stream().map(each -> each.getDataSourceName().length() - prefix.length()).min(Comparator.comparing(Integer::intValue)).orElse(1);
        return new DataNodeInfo(prefix, suffixMinLength, '0');
    }

    private DataNodeInfo createTableDataNode(Collection<DataNode> actualDataNodes) {
        String prefix = DATA_NODE_SUFFIX_PATTERN.matcher(actualDataNodes.iterator().next().getTableName()).replaceAll("");
        int suffixMinLength = actualDataNodes.stream().map(each -> each.getTableName().length() - prefix.length()).min(Comparator.comparing(Integer::intValue)).orElse(1);
        return new DataNodeInfo(prefix, suffixMinLength, '0');
    }

    private List<String> getDataNodes(ShardingAutoTableRuleConfiguration tableRuleConfig, ShardingAutoTableAlgorithm shardingAlgorithm, Collection<String> dataSourceNames) {
        if (null == this.tableShardingStrategyConfig) {
            return new LinkedList<String>();
        }
        LinkedList<String> dataSources = Strings.isNullOrEmpty((String)tableRuleConfig.getActualDataSources()) ? new LinkedList<String>(dataSourceNames) : new InlineExpressionParser(tableRuleConfig.getActualDataSources()).splitAndEvaluate();
        return this.fillDataSourceNames(shardingAlgorithm.getAutoTablesAmount(), dataSources);
    }

    private List<String> fillDataSourceNames(int amount, List<String> dataSources) {
        LinkedList<String> result = new LinkedList<String>();
        Iterator<String> iterator = dataSources.iterator();
        for (int i = 0; i < amount; ++i) {
            if (!iterator.hasNext()) {
                iterator = dataSources.iterator();
            }
            result.add(String.format("%s.%s_%s", iterator.next(), this.logicTable, i));
        }
        return result;
    }

    private Set<String> getActualTables() {
        return this.actualDataNodes.stream().map(DataNode::getTableName).collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER)));
    }

    private void addActualTable(String datasourceName, String tableName) {
        this.datasourceToTablesMap.computeIfAbsent(datasourceName, key -> new LinkedHashSet()).add(tableName);
    }

    private boolean isEmptyDataNodes(List<String> dataNodes) {
        return null == dataNodes || dataNodes.isEmpty();
    }

    private List<DataNode> generateDataNodes(String logicTable, Collection<String> dataSourceNames) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        int index = 0;
        for (String each : dataSourceNames) {
            DataNode dataNode = new DataNode(each, logicTable);
            result.add(dataNode);
            this.dataNodeIndexMap.put(dataNode, index);
            this.actualDatasourceNames.add(each);
            this.addActualTable(dataNode.getDataSourceName(), dataNode.getTableName());
            ++index;
        }
        return result;
    }

    private List<DataNode> generateDataNodes(List<String> actualDataNodes, Collection<String> dataSourceNames) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        int index = 0;
        for (String each : actualDataNodes) {
            DataNode dataNode = new DataNode(each);
            if (!dataSourceNames.contains(dataNode.getDataSourceName())) {
                throw new ShardingSphereException("Cannot find data source in sharding rule, invalid actual data node is: '%s'", new Object[]{each});
            }
            result.add(dataNode);
            this.dataNodeIndexMap.put(dataNode, index);
            this.actualDatasourceNames.add(dataNode.getDataSourceName());
            this.addActualTable(dataNode.getDataSourceName(), dataNode.getTableName());
            ++index;
        }
        return result;
    }

    public Map<String, List<DataNode>> getDataNodeGroups() {
        return DataNodeUtil.getDataNodeGroups(this.actualDataNodes);
    }

    public Collection<String> getActualDatasourceNames() {
        return this.actualDatasourceNames;
    }

    public Collection<String> getActualTableNames(String targetDataSource) {
        return this.datasourceToTablesMap.getOrDefault(targetDataSource, Collections.emptySet());
    }

    int findActualTableIndex(String dataSourceName, String actualTableName) {
        return this.dataNodeIndexMap.getOrDefault(new DataNode(dataSourceName, actualTableName), -1);
    }

    boolean isExisted(String actualTableName) {
        return this.actualTables.contains(actualTableName);
    }

    private void checkRule(List<String> dataNodes) {
        if (this.isEmptyDataNodes(dataNodes) && null != this.tableShardingStrategyConfig && !(this.tableShardingStrategyConfig instanceof NoneShardingStrategyConfiguration)) {
            throw new ShardingSphereConfigurationException("ActualDataNodes must be configured if want to shard tables for logicTable [%s]", new Object[]{this.logicTable});
        }
    }

    public Optional<String> getGenerateKeyColumn() {
        return Optional.ofNullable(this.generateKeyColumn);
    }

    @Generated
    public String getLogicTable() {
        return this.logicTable;
    }

    @Generated
    public List<DataNode> getActualDataNodes() {
        return this.actualDataNodes;
    }

    @Generated
    public ShardingStrategyConfiguration getDatabaseShardingStrategyConfig() {
        return this.databaseShardingStrategyConfig;
    }

    @Generated
    public ShardingStrategyConfiguration getTableShardingStrategyConfig() {
        return this.tableShardingStrategyConfig;
    }

    @Generated
    public String getKeyGeneratorName() {
        return this.keyGeneratorName;
    }

    @Generated
    public Map<String, Collection<String>> getDatasourceToTablesMap() {
        return this.datasourceToTablesMap;
    }

    @Generated
    public DataNodeInfo getDataSourceDataNode() {
        return this.dataSourceDataNode;
    }

    @Generated
    public DataNodeInfo getTableDataNode() {
        return this.tableDataNode;
    }

    @Generated
    public String toString() {
        return "TableRule(logicTable=" + this.getLogicTable() + ", actualDataNodes=" + this.getActualDataNodes() + ", databaseShardingStrategyConfig=" + this.getDatabaseShardingStrategyConfig() + ", tableShardingStrategyConfig=" + this.getTableShardingStrategyConfig() + ", generateKeyColumn=" + this.getGenerateKeyColumn() + ", keyGeneratorName=" + this.getKeyGeneratorName() + ")";
    }
}

