/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.dml.impl;

import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sharding.route.engine.type.standard.ShardingStandardRoutingEngine;
import org.apache.shardingsphere.sharding.route.engine.validator.dml.ShardingDMLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.UpdateStatementHandler;

public final class ShardingUpdateStatementValidator
extends ShardingDMLStatementValidator<UpdateStatement> {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext<UpdateStatement> sqlStatementContext, List<Object> parameters, ShardingSphereSchema schema) {
        this.validateMultipleTable(shardingRule, sqlStatementContext);
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext<UpdateStatement> sqlStatementContext, List<Object> parameters, ShardingSphereSchema schema, ConfigurationProperties props, RouteContext routeContext) {
        String tableName = (String)sqlStatementContext.getTablesContext().getTableNames().iterator().next();
        Optional<ShardingConditions> shardingConditions = this.createShardingConditions(sqlStatementContext, shardingRule, ((UpdateStatement)sqlStatementContext.getSqlStatement()).getSetAssignment().getAssignments(), parameters);
        Optional<RouteContext> setAssignmentRouteContext = shardingConditions.map(optional -> new ShardingStandardRoutingEngine(tableName, (ShardingConditions)optional, props).route(shardingRule));
        if (setAssignmentRouteContext.isPresent() && !this.isSameRouteContext(routeContext, setAssignmentRouteContext.get())) {
            throw new ShardingSphereException("Can not update sharding key since the updated value will change %s's data nodes.", new Object[]{tableName});
        }
        if (UpdateStatementHandler.getLimitSegment((UpdateStatement)((UpdateStatement)sqlStatementContext.getSqlStatement())).isPresent() && routeContext.getRouteUnits().size() > 1) {
            throw new ShardingSphereException("UPDATE ... LIMIT can not support sharding route to multiple data nodes.", new Object[0]);
        }
    }
}

