/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.type.federated;

import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngine;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;

public final class ShardingFederatedRoutingEngine
implements ShardingRouteEngine {
    private final Collection<String> logicTables;

    @Override
    public RouteContext route(ShardingRule shardingRule) {
        RouteContext result = new RouteContext();
        for (String each : this.logicTables) {
            this.fillRouteContext(result, shardingRule, each);
        }
        result.setFederated(true);
        return result;
    }

    private void fillRouteContext(RouteContext routeContext, ShardingRule shardingRule, String logicTableName) {
        TableRule tableRule = shardingRule.getTableRule(logicTableName);
        for (DataNode each : tableRule.getActualDataNodes()) {
            RouteMapper dataSource = new RouteMapper(each.getDataSourceName(), each.getDataSourceName());
            RouteMapper table = new RouteMapper(logicTableName, each.getTableName());
            routeContext.putRouteUnit(dataSource, Collections.singletonList(table));
        }
    }

    @Generated
    public ShardingFederatedRoutingEngine(Collection<String> logicTables) {
        this.logicTables = logicTables;
    }
}

