/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dql.pagination;

import java.sql.SQLException;
import org.apache.shardingsphere.infra.binder.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.decorator.DecoratorMergedResult;

public final class LimitDecoratorMergedResult
extends DecoratorMergedResult {
    private final PaginationContext pagination;
    private final boolean skipAll;
    private int rowNumber;

    public LimitDecoratorMergedResult(MergedResult mergedResult, PaginationContext pagination) throws SQLException {
        super(mergedResult);
        this.pagination = pagination;
        this.skipAll = this.skipOffset();
    }

    private boolean skipOffset() throws SQLException {
        int i = 0;
        while ((long)i < this.pagination.getActualOffset()) {
            if (!this.getMergedResult().next()) {
                return true;
            }
            ++i;
        }
        this.rowNumber = 0;
        return false;
    }

    public boolean next() throws SQLException {
        if (this.skipAll) {
            return false;
        }
        if (!this.pagination.getActualRowCount().isPresent()) {
            return this.getMergedResult().next();
        }
        return (long)(++this.rowNumber) <= (Long)this.pagination.getActualRowCount().get() && this.getMergedResult().next();
    }
}

