/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dal.show;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryQueryResultRow;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.model.ConstraintMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.metadata.schema.util.IndexMetaDataUtil;
import org.apache.shardingsphere.sharding.merge.dal.show.LogicTablesMergedResult;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;

public final class ShowCreateTableMergedResult
extends LogicTablesMergedResult {
    public ShowCreateTableMergedResult(ShardingRule shardingRule, SQLStatementContext<?> sqlStatementContext, ShardingSphereSchema schema, List<QueryResult> queryResults) throws SQLException {
        super(shardingRule, sqlStatementContext, schema, queryResults);
    }

    @Override
    protected void setCellValue(MemoryQueryResultRow memoryResultSetRow, String logicTableName, String actualTableName, TableMetaData tableMetaData, ShardingRule shardingRule) {
        String actualIndexName;
        memoryResultSetRow.setCell(2, (Object)memoryResultSetRow.getCell(2).toString().replaceFirst(actualTableName, logicTableName));
        for (String string : tableMetaData.getIndexes().keySet()) {
            actualIndexName = IndexMetaDataUtil.getActualIndexName((String)string, (String)actualTableName);
            memoryResultSetRow.setCell(2, (Object)memoryResultSetRow.getCell(2).toString().replace(actualIndexName, string));
        }
        for (Map.Entry entry : tableMetaData.getConstrains().entrySet()) {
            actualIndexName = IndexMetaDataUtil.getActualIndexName((String)((String)entry.getKey()), (String)actualTableName);
            memoryResultSetRow.setCell(2, (Object)memoryResultSetRow.getCell(2).toString().replace(actualIndexName, (CharSequence)entry.getKey()));
            Optional<TableRule> tableRule = shardingRule.findTableRule(((ConstraintMetaData)entry.getValue()).getReferencedTableName());
            if (!tableRule.isPresent()) continue;
            for (DataNode dataNode : tableRule.get().getActualDataNodes()) {
                memoryResultSetRow.setCell(2, (Object)memoryResultSetRow.getCell(2).toString().replace(dataNode.getTableName(), ((ConstraintMetaData)entry.getValue()).getReferencedTableName()));
            }
        }
    }
}

