/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.cosid;

import com.google.common.base.Strings;
import java.time.LocalDateTime;
import me.ahoo.cosid.converter.Radix62IdConverter;
import me.ahoo.cosid.snowflake.MillisecondSnowflakeIdStateParser;
import me.ahoo.cosid.snowflake.SnowflakeIdStateParser;
import org.apache.shardingsphere.sharding.algorithm.keygen.CosIdSnowflakeKeyGenerateAlgorithm;
import org.apache.shardingsphere.sharding.algorithm.sharding.cosid.AbstractIntervalShardingAlgorithm;

public final class CosIdSnowflakeIntervalShardingAlgorithm
extends AbstractIntervalShardingAlgorithm<Comparable<?>> {
    public static final String TYPE = "COSID_INTERVAL_SNOWFLAKE";
    public static final String EPOCH_KEY = "epoch";
    private volatile SnowflakeIdStateParser snowflakeIdStateParser;

    @Override
    public void init() {
        super.init();
        long epoch = CosIdSnowflakeKeyGenerateAlgorithm.DEFAULT_EPOCH;
        if (this.getProps().containsKey(EPOCH_KEY)) {
            epoch = Long.parseLong(this.getProps().getProperty(EPOCH_KEY));
        }
        this.snowflakeIdStateParser = new MillisecondSnowflakeIdStateParser(epoch, 41, 10, 12, this.getZoneId());
    }

    @Override
    protected LocalDateTime convertShardingValue(Comparable<?> shardingValue) {
        Long snowflakeId = this.convertToSnowflakeId(shardingValue);
        return this.snowflakeIdStateParser.parseTimestamp(snowflakeId.longValue());
    }

    private Long convertToSnowflakeId(Comparable<?> shardingValue) {
        if (shardingValue instanceof Long) {
            return (Long)shardingValue;
        }
        if (shardingValue instanceof String) {
            String shardingValueStr = (String)((Object)shardingValue);
            return Radix62IdConverter.PAD_START.asLong(shardingValueStr);
        }
        throw new IllegalArgumentException(Strings.lenientFormat((String)"The current shard type:[%s] is not supported!", (Object[])new Object[]{shardingValue.getClass()}));
    }

    public String getType() {
        return TYPE;
    }
}

