/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.cosid;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Properties;
import lombok.Generated;
import me.ahoo.cosid.sharding.IntervalStep;
import me.ahoo.cosid.sharding.IntervalTimeline;
import org.apache.shardingsphere.sharding.algorithm.sharding.cosid.PropertiesUtil;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;

public abstract class AbstractIntervalShardingAlgorithm<T extends Comparable<?>>
implements StandardShardingAlgorithm<T> {
    public static final String DEFAULT_DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final String DATE_TIME_LOWER_KEY = "datetime-lower";
    public static final String DATE_TIME_UPPER_KEY = "datetime-upper";
    public static final String SHARDING_SUFFIX_FORMAT_KEY = "sharding-suffix-pattern";
    public static final String INTERVAL_UNIT_KEY = "datetime-interval-unit";
    public static final String INTERVAL_AMOUNT_KEY = "datetime-interval-amount";
    public static final String ZONE_ID_KEY = "zone-id";
    private volatile IntervalTimeline intervalTimeline;
    private ZoneId zoneId = ZoneId.systemDefault();
    private Properties props = new Properties();

    protected ZoneId getZoneId() {
        return this.zoneId;
    }

    public void init() {
        if (this.getProps().containsKey(ZONE_ID_KEY)) {
            this.zoneId = ZoneId.of(this.getRequiredValue(ZONE_ID_KEY));
        }
        String logicNamePrefix = this.getRequiredValue("logic-name-prefix");
        LocalDateTime effectiveLower = LocalDateTime.parse(this.getRequiredValue(DATE_TIME_LOWER_KEY), DEFAULT_DATE_TIME_FORMATTER);
        LocalDateTime effectiveUpper = LocalDateTime.parse(this.getRequiredValue(DATE_TIME_UPPER_KEY), DEFAULT_DATE_TIME_FORMATTER);
        DateTimeFormatter suffixFormatter = DateTimeFormatter.ofPattern(this.getRequiredValue(SHARDING_SUFFIX_FORMAT_KEY));
        ChronoUnit stepUnit = ChronoUnit.valueOf(this.getRequiredValue(INTERVAL_UNIT_KEY));
        int stepAmount = Integer.parseInt(this.getProps().getOrDefault((Object)INTERVAL_AMOUNT_KEY, (Object)1).toString());
        this.intervalTimeline = new IntervalTimeline(logicNamePrefix, Range.closed((Comparable)effectiveLower, (Comparable)effectiveUpper), IntervalStep.of((ChronoUnit)stepUnit, (int)stepAmount), suffixFormatter);
    }

    private String getRequiredValue(String key) {
        return PropertiesUtil.getRequiredValue(this.getProps(), key);
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<T> shardingValue) {
        LocalDateTime shardingTime = this.convertShardingValue(shardingValue.getValue());
        return this.intervalTimeline.sharding(shardingTime);
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<T> shardingValue) {
        Range<LocalDateTime> shardingRangeTime = this.convertRangeShardingValue(shardingValue.getValueRange());
        return this.intervalTimeline.sharding(shardingRangeTime);
    }

    protected abstract LocalDateTime convertShardingValue(T var1);

    private Range<LocalDateTime> convertRangeShardingValue(Range<T> shardingValue) {
        Comparable endpointValue;
        if (Range.all().equals(shardingValue)) {
            return Range.all();
        }
        Comparable comparable = endpointValue = shardingValue.hasLowerBound() ? shardingValue.lowerEndpoint() : shardingValue.upperEndpoint();
        if (endpointValue instanceof LocalDateTime) {
            return shardingValue;
        }
        if (shardingValue.hasLowerBound() && shardingValue.hasUpperBound()) {
            LocalDateTime lower = this.convertShardingValue(shardingValue.lowerEndpoint());
            LocalDateTime upper = this.convertShardingValue(shardingValue.upperEndpoint());
            return Range.range((Comparable)lower, (BoundType)shardingValue.lowerBoundType(), (Comparable)upper, (BoundType)shardingValue.upperBoundType());
        }
        if (shardingValue.hasLowerBound()) {
            LocalDateTime lower = this.convertShardingValue(shardingValue.lowerEndpoint());
            if (BoundType.OPEN.equals((Object)shardingValue.lowerBoundType())) {
                return Range.greaterThan((Comparable)lower);
            }
            return Range.atLeast((Comparable)lower);
        }
        LocalDateTime upper = this.convertShardingValue(shardingValue.upperEndpoint());
        if (BoundType.OPEN.equals((Object)shardingValue.upperBoundType())) {
            return Range.lessThan((Comparable)upper);
        }
        return Range.atMost((Comparable)upper);
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

