/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.keygen;

import com.google.common.base.Preconditions;
import java.util.Properties;
import lombok.Generated;
import me.ahoo.cosid.converter.Radix62IdConverter;
import me.ahoo.cosid.snowflake.ClockSyncSnowflakeId;
import me.ahoo.cosid.snowflake.MillisecondSnowflakeId;
import me.ahoo.cosid.snowflake.SnowflakeId;
import me.ahoo.cosid.snowflake.StringSnowflakeId;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereInstanceRequiredAlgorithm;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.sharding.algorithm.keygen.SnowflakeKeyGenerateAlgorithm;
import org.apache.shardingsphere.sharding.spi.KeyGenerateAlgorithm;

public final class CosIdSnowflakeKeyGenerateAlgorithm
implements KeyGenerateAlgorithm,
ShardingSphereInstanceRequiredAlgorithm {
    public static final String TYPE = "COSID_SNOWFLAKE";
    public static final long DEFAULT_EPOCH = SnowflakeKeyGenerateAlgorithm.EPOCH;
    public static final String AS_STRING_KEY = "as-string";
    public static final String EPOCH_KEY = "epoch";
    private volatile SnowflakeId snowflakeId;
    private volatile boolean asString;
    private Properties props = new Properties();

    public void init() {
        String asStringStr = this.getProps().getProperty(AS_STRING_KEY, Boolean.FALSE.toString());
        this.asString = Boolean.parseBoolean(asStringStr);
    }

    public Comparable<?> generateKey() {
        if (this.asString) {
            return this.getSnowflakeId().generateAsString();
        }
        return this.getSnowflakeId().generate();
    }

    private SnowflakeId getSnowflakeId() {
        Preconditions.checkNotNull((Object)this.snowflakeId, (Object)"Instance context not set yet.");
        return this.snowflakeId;
    }

    public void setInstanceContext(InstanceContext instanceContext) {
        long workerId = instanceContext.getWorkerId();
        long epoch = DEFAULT_EPOCH;
        if (this.props.containsKey(EPOCH_KEY)) {
            epoch = Long.parseLong(this.props.getProperty(EPOCH_KEY));
        }
        MillisecondSnowflakeId millisecondSnowflakeId = new MillisecondSnowflakeId(epoch, 41, 10, 12, workerId);
        ClockSyncSnowflakeId clockSyncSnowflakeId = new ClockSyncSnowflakeId((SnowflakeId)millisecondSnowflakeId);
        this.snowflakeId = new StringSnowflakeId((SnowflakeId)clockSyncSnowflakeId, Radix62IdConverter.PAD_START);
    }

    public String getType() {
        return TYPE;
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

