/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.yaml.swapper;

import org.apache.shardingsphere.infra.yaml.config.swapper.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.algorithm.ShardingSphereAlgorithmConfigurationYamlSwapper;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.api.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.YamlShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.datasource.YamlShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.table.YamlShadowTableConfiguration;
import org.apache.shardingsphere.shadow.yaml.swapper.datasource.ShadowDataSourceConfigurationYamlSwapper;
import org.apache.shardingsphere.shadow.yaml.swapper.table.ShadowTableConfigurationYamlSwapper;

public final class ShadowRuleConfigurationYamlSwapper
implements YamlRuleConfigurationSwapper<YamlShadowRuleConfiguration, ShadowRuleConfiguration> {
    private final ShadowDataSourceConfigurationYamlSwapper dataSourceConfigurationSwapper = new ShadowDataSourceConfigurationYamlSwapper();
    private final ShadowTableConfigurationYamlSwapper tableConfigurationYamlSwapper = new ShadowTableConfigurationYamlSwapper();
    private final ShardingSphereAlgorithmConfigurationYamlSwapper algorithmSwapper = new ShardingSphereAlgorithmConfigurationYamlSwapper();

    public YamlShadowRuleConfiguration swapToYamlConfiguration(ShadowRuleConfiguration dataConfiguration) {
        YamlShadowRuleConfiguration result = new YamlShadowRuleConfiguration();
        result.setDefaultShadowAlgorithmName(dataConfiguration.getDefaultShadowAlgorithmName());
        this.parseDataSources(dataConfiguration, result);
        this.parseShadowTables(dataConfiguration, result);
        this.parseShadowAlgorithms(dataConfiguration, result);
        return result;
    }

    private void parseShadowAlgorithms(ShadowRuleConfiguration dataConfiguration, YamlShadowRuleConfiguration yamlConfiguration) {
        dataConfiguration.getShadowAlgorithms().forEach((key, value) -> yamlConfiguration.getShadowAlgorithms().put((String)key, this.algorithmSwapper.swapToYamlConfiguration(value)));
    }

    private void parseShadowTables(ShadowRuleConfiguration dataConfiguration, YamlShadowRuleConfiguration yamlConfiguration) {
        dataConfiguration.getTables().forEach((key, value) -> yamlConfiguration.getTables().put((String)key, this.tableConfigurationYamlSwapper.swapToYamlConfiguration((ShadowTableConfiguration)value)));
    }

    private void parseDataSources(ShadowRuleConfiguration dataConfiguration, YamlShadowRuleConfiguration yamlConfiguration) {
        dataConfiguration.getDataSources().forEach((key, value) -> yamlConfiguration.getDataSources().put((String)key, this.dataSourceConfigurationSwapper.swapToYamlConfiguration((ShadowDataSourceConfiguration)value)));
    }

    public ShadowRuleConfiguration swapToObject(YamlShadowRuleConfiguration yamlConfiguration) {
        ShadowRuleConfiguration result = new ShadowRuleConfiguration();
        result.setDefaultShadowAlgorithmName(yamlConfiguration.getDefaultShadowAlgorithmName());
        this.parseYamlDataSources(yamlConfiguration, result);
        this.parseYamlShadowTables(yamlConfiguration, result);
        this.parseYamlShadowAlgorithms(yamlConfiguration, result);
        return result;
    }

    private void parseYamlShadowAlgorithms(YamlShadowRuleConfiguration yamlConfiguration, ShadowRuleConfiguration dataConfiguration) {
        yamlConfiguration.getShadowAlgorithms().forEach((key, value) -> dataConfiguration.getShadowAlgorithms().put(key, this.algorithmSwapper.swapToObject(value)));
    }

    private void parseYamlShadowTables(YamlShadowRuleConfiguration yamlConfiguration, ShadowRuleConfiguration dataConfiguration) {
        yamlConfiguration.getTables().forEach((key, value) -> dataConfiguration.getTables().put(key, this.tableConfigurationYamlSwapper.swapToObject((YamlShadowTableConfiguration)value)));
    }

    private void parseYamlDataSources(YamlShadowRuleConfiguration yamlConfiguration, ShadowRuleConfiguration dataConfiguration) {
        yamlConfiguration.getDataSources().forEach((key, value) -> dataConfiguration.getDataSources().put(key, this.dataSourceConfigurationSwapper.swapToObject((YamlShadowDataSourceConfiguration)value)));
    }

    public Class<ShadowRuleConfiguration> getTypeClass() {
        return ShadowRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "SHADOW";
    }

    public int getOrder() {
        return 40;
    }
}

