/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.yaml.swapper;

import org.apache.shardingsphere.infra.yaml.config.pojo.algorithm.YamlShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.shadow.algorithm.config.AlgorithmProvidedShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.api.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.YamlShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.datasource.YamlShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.table.YamlShadowTableConfiguration;
import org.apache.shardingsphere.shadow.yaml.swapper.datasource.ShadowDataSourceConfigurationYamlSwapper;
import org.apache.shardingsphere.shadow.yaml.swapper.table.ShadowTableConfigurationYamlSwapper;

public final class ShadowRuleAlgorithmProviderConfigurationYamlSwapper
implements YamlRuleConfigurationSwapper<YamlShadowRuleConfiguration, AlgorithmProvidedShadowRuleConfiguration> {
    private final ShadowDataSourceConfigurationYamlSwapper dataSourceConfigurationSwapper = new ShadowDataSourceConfigurationYamlSwapper();
    private final ShadowTableConfigurationYamlSwapper tableConfigurationYamlSwapper = new ShadowTableConfigurationYamlSwapper();

    public YamlShadowRuleConfiguration swapToYamlConfiguration(AlgorithmProvidedShadowRuleConfiguration dataConfiguration) {
        YamlShadowRuleConfiguration result = new YamlShadowRuleConfiguration();
        result.setDefaultShadowAlgorithmName(dataConfiguration.getDefaultShadowAlgorithmName());
        this.parseDataSources(dataConfiguration, result);
        this.parseShadowTables(dataConfiguration, result);
        this.parseShadowAlgorithms(dataConfiguration, result);
        return result;
    }

    private void parseShadowAlgorithms(AlgorithmProvidedShadowRuleConfiguration dataConfiguration, YamlShadowRuleConfiguration yamlConfiguration) {
        dataConfiguration.getShadowAlgorithms().forEach((key, value) -> yamlConfiguration.getShadowAlgorithms().put((String)key, new YamlShardingSphereAlgorithmConfiguration(value.getType(), value.getProps())));
    }

    private void parseShadowTables(AlgorithmProvidedShadowRuleConfiguration dataConfiguration, YamlShadowRuleConfiguration yamlConfiguration) {
        dataConfiguration.getTables().forEach((key, value) -> yamlConfiguration.getTables().put((String)key, this.tableConfigurationYamlSwapper.swapToYamlConfiguration((ShadowTableConfiguration)value)));
    }

    private void parseDataSources(AlgorithmProvidedShadowRuleConfiguration dataConfiguration, YamlShadowRuleConfiguration yamlConfiguration) {
        dataConfiguration.getDataSources().forEach((key, value) -> yamlConfiguration.getDataSources().put((String)key, this.dataSourceConfigurationSwapper.swapToYamlConfiguration((ShadowDataSourceConfiguration)value)));
    }

    public AlgorithmProvidedShadowRuleConfiguration swapToObject(YamlShadowRuleConfiguration yamlConfiguration) {
        AlgorithmProvidedShadowRuleConfiguration result = new AlgorithmProvidedShadowRuleConfiguration();
        result.setDefaultShadowAlgorithmName(yamlConfiguration.getDefaultShadowAlgorithmName());
        this.parseYamlDataSources(yamlConfiguration, result);
        this.parseYamlShadowTables(yamlConfiguration, result);
        return result;
    }

    private void parseYamlShadowTables(YamlShadowRuleConfiguration yamlConfiguration, AlgorithmProvidedShadowRuleConfiguration dataConfiguration) {
        yamlConfiguration.getTables().forEach((key, value) -> dataConfiguration.getTables().put((String)key, this.tableConfigurationYamlSwapper.swapToObject((YamlShadowTableConfiguration)value)));
    }

    private void parseYamlDataSources(YamlShadowRuleConfiguration yamlConfiguration, AlgorithmProvidedShadowRuleConfiguration dataConfiguration) {
        yamlConfiguration.getDataSources().forEach((key, value) -> dataConfiguration.getDataSources().put((String)key, this.dataSourceConfigurationSwapper.swapToObject((YamlShadowDataSourceConfiguration)value)));
    }

    public Class<AlgorithmProvidedShadowRuleConfiguration> getTypeClass() {
        return AlgorithmProvidedShadowRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "SHADOW";
    }

    public int getOrder() {
        return 41;
    }
}

