/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.dml;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.dml.UpdateStatementContext;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.condition.ShadowColumnCondition;
import org.apache.shardingsphere.shadow.route.engine.dml.AbstractShadowDMLStatementRouteEngine;
import org.apache.shardingsphere.shadow.route.engine.util.ShadowExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionExtractUtil;

public final class ShadowUpdateStatementRoutingEngine
extends AbstractShadowDMLStatementRouteEngine {
    private final UpdateStatementContext updateStatementContext;
    private final List<Object> parameters;

    @Override
    protected Collection<SimpleTableSegment> getAllTables() {
        return this.updateStatementContext.getAllTables();
    }

    @Override
    protected ShadowOperationType getShadowOperationType() {
        return ShadowOperationType.UPDATE;
    }

    @Override
    protected Optional<Collection<String>> parseSQLComments() {
        LinkedList result = new LinkedList();
        ((UpdateStatement)this.updateStatementContext.getSqlStatement()).getCommentSegments().forEach(each -> result.add(each.getText()));
        return result.isEmpty() ? Optional.empty() : Optional.of(result);
    }

    @Override
    protected Iterator<Optional<ShadowColumnCondition>> getShadowColumnConditionIterator() {
        return new ShadowColumnConditionIterator(this.parseWhereSegment(), this.parameters);
    }

    private Collection<ExpressionSegment> parseWhereSegment() {
        LinkedList<ExpressionSegment> result = new LinkedList<ExpressionSegment>();
        for (WhereSegment each : this.updateStatementContext.getWhereSegments()) {
            for (AndPredicate predicate : ExpressionExtractUtil.getAndPredicates((ExpressionSegment)each.getExpr())) {
                result.addAll(predicate.getPredicates());
            }
        }
        return result;
    }

    @Generated
    public ShadowUpdateStatementRoutingEngine(UpdateStatementContext updateStatementContext, List<Object> parameters) {
        this.updateStatementContext = updateStatementContext;
        this.parameters = parameters;
    }

    private class ShadowColumnConditionIterator
    implements Iterator<Optional<ShadowColumnCondition>> {
        private final Iterator<ExpressionSegment> iterator;
        private final List<Object> parameters;

        ShadowColumnConditionIterator(Collection<ExpressionSegment> predicates, List<Object> parameters) {
            this.iterator = predicates.iterator();
            this.parameters = parameters;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Optional<ShadowColumnCondition> next() {
            ExpressionSegment expressionSegment = this.iterator.next();
            return ShadowExtractor.extractColumn(expressionSegment).flatMap(segment -> ShadowExtractor.extractValues(expressionSegment, this.parameters).map(values -> new ShadowColumnCondition(ShadowUpdateStatementRoutingEngine.this.getSingleTableName(), segment.getIdentifier().getValue(), (Collection<Comparable<?>>)values)));
        }
    }
}

