/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.shadow.rule.ShadowRule;

public interface ShadowRouteEngine {
    default public void shadowRouteDecorate(RouteContext routeContext, ShadowRule shadowRule, Map<String, String> shadowDataSourceMappings) {
        Collection routeUnits = routeContext.getRouteUnits();
        LinkedList<RouteUnit> toBeRemoved = new LinkedList<RouteUnit>();
        LinkedList<RouteUnit> toBeAdded = new LinkedList<RouteUnit>();
        for (RouteUnit each : routeUnits) {
            String logicName = each.getDataSourceMapper().getLogicName();
            String shadowLogicName = each.getDataSourceMapper().getActualName();
            Optional<String> sourceDataSourceNameOptional = shadowRule.getSourceDataSourceName(shadowLogicName);
            if (!sourceDataSourceNameOptional.isPresent()) continue;
            String sourceDataSourceName = sourceDataSourceNameOptional.get();
            String shadowDataSourceName = shadowDataSourceMappings.get(sourceDataSourceName);
            toBeRemoved.add(each);
            toBeAdded.add(null == shadowDataSourceName ? new RouteUnit(new RouteMapper(logicName, sourceDataSourceName), each.getTableMappers()) : new RouteUnit(new RouteMapper(logicName, shadowDataSourceName), each.getTableMappers()));
        }
        routeUnits.removeAll(toBeRemoved);
        routeUnits.addAll(toBeAdded);
    }

    public void route(RouteContext var1, ShadowRule var2);
}

