/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.checker;

import java.util.Map;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.checker.AbstractShadowRuleConfigurationChecker;

public final class ShadowRuleConfigurationChecker
extends AbstractShadowRuleConfigurationChecker<ShadowRuleConfiguration> {
    @Override
    protected void checkShadowRuleConfiguration(ShadowRuleConfiguration config) {
        Map dataSources = config.getDataSources();
        Map shadowTables = config.getTables();
        Map shadowAlgorithmConfigurations = config.getShadowAlgorithms();
        String defaultShadowAlgorithmName = config.getDefaultShadowAlgorithmName();
        this.sizeCheck(dataSources, shadowTables, defaultShadowAlgorithmName);
        this.shadowAlgorithmConfigurationsSizeCheck(shadowAlgorithmConfigurations);
        this.shadowTableDataSourcesAutoReferences(shadowTables, dataSources);
        this.shadowTableDataSourcesReferencesCheck(shadowTables, dataSources);
        this.defaultShadowAlgorithmConfigurationCheck(defaultShadowAlgorithmName, shadowAlgorithmConfigurations);
        this.shadowTableAlgorithmsAutoReferences(shadowTables, shadowAlgorithmConfigurations.keySet(), defaultShadowAlgorithmName);
        this.shadowTableAlgorithmsReferencesCheck(shadowTables);
    }

    public int getOrder() {
        return 40;
    }

    public Class<ShadowRuleConfiguration> getTypeClass() {
        return ShadowRuleConfiguration.class;
    }
}

